/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.HardwareVideoEncoderWrapper;
import org.webrtc.Logging;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

class HardwareVideoEncoderWrapperFactory
implements VideoEncoderFactory {
    private static final String TAG = "HardwareVideoEncoderWrapperFactory";
    private final HardwareVideoEncoderFactory factory;
    private final int resolutionPixelAlignment;

    public HardwareVideoEncoderWrapperFactory(HardwareVideoEncoderFactory factory, int resolutionPixelAlignment) {
        this.factory = factory;
        this.resolutionPixelAlignment = resolutionPixelAlignment;
        if (resolutionPixelAlignment == 0) {
            throw new IllegalArgumentException("resolutionPixelAlignment should not be 0");
        }
    }

    @Override
    public VideoEncoder createEncoder(VideoCodecInfo videoCodecInfo) {
        try {
            VideoEncoder encoder = this.factory.createEncoder(videoCodecInfo);
            if (encoder == null) {
                return null;
            }
            return new HardwareVideoEncoderWrapper(encoder, this.resolutionPixelAlignment);
        }
        catch (Exception e) {
            Logging.e(TAG, "createEncoder failed", e);
            return null;
        }
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return this.factory.getSupportedCodecs();
    }
}

