/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.EglBase;
import org.webrtc.HardwareVideoEncoderFactory;
import org.webrtc.HardwareVideoEncoderWrapperFactory;
import org.webrtc.Logging;
import org.webrtc.ResolutionAdjustment;
import org.webrtc.SimulcastVideoEncoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoFrame;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/webrtc/SimulcastAlignedVideoEncoderFactory;", "Lorg/webrtc/VideoEncoderFactory;", "sharedContext", "Lorg/webrtc/EglBase$Context;", "enableIntelVp8Encoder", "", "enableH264HighProfile", "resolutionAdjustment", "Lorg/webrtc/ResolutionAdjustment;", "(Lorg/webrtc/EglBase$Context;ZZLorg/webrtc/ResolutionAdjustment;)V", "fallback", "native", "Lorg/webrtc/SimulcastVideoEncoderFactory;", "primary", "createEncoder", "Lorg/webrtc/VideoEncoder;", "info", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "StreamEncoderWrapper", "StreamEncoderWrapperFactory", "stream-webrtc-android_release"})
public final class SimulcastAlignedVideoEncoderFactory
implements VideoEncoderFactory {
    @NotNull
    private final VideoEncoderFactory primary;
    @Nullable
    private final VideoEncoderFactory fallback;
    @NotNull
    private final SimulcastVideoEncoderFactory native;

    public SimulcastAlignedVideoEncoderFactory(@Nullable EglBase.Context sharedContext, boolean enableIntelVp8Encoder, boolean enableH264HighProfile, @NotNull ResolutionAdjustment resolutionAdjustment) {
        Intrinsics.checkNotNullParameter((Object)((Object)resolutionAdjustment), (String)"resolutionAdjustment");
        HardwareVideoEncoderFactory hardwareVideoEncoderFactory = new HardwareVideoEncoderFactory(sharedContext, enableIntelVp8Encoder, enableH264HighProfile);
        VideoEncoderFactory encoderFactory = resolutionAdjustment == ResolutionAdjustment.NONE ? (VideoEncoderFactory)hardwareVideoEncoderFactory : (VideoEncoderFactory)new HardwareVideoEncoderWrapperFactory(hardwareVideoEncoderFactory, resolutionAdjustment.getValue());
        this.primary = new StreamEncoderWrapperFactory(encoderFactory);
        this.fallback = new SoftwareVideoEncoderFactory();
        this.native = new SimulcastVideoEncoderFactory(this.primary, this.fallback);
    }

    public /* synthetic */ SimulcastAlignedVideoEncoderFactory(EglBase.Context context, boolean bl, boolean bl2, ResolutionAdjustment resolutionAdjustment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(context, bl, bl2, resolutionAdjustment);
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(@Nullable VideoCodecInfo info) {
        return this.native.createEncoder(info);
    }

    @Override
    @NotNull
    public VideoCodecInfo[] getSupportedCodecs() {
        VideoCodecInfo[] videoCodecInfoArray = this.native.getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"getSupportedCodecs(...)");
        return videoCodecInfoArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\u001a\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/webrtc/SimulcastAlignedVideoEncoderFactory$StreamEncoderWrapper;", "Lorg/webrtc/VideoEncoder;", "encoder", "(Lorg/webrtc/VideoEncoder;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "streamSettings", "Lorg/webrtc/VideoEncoder$Settings;", "encode", "Lorg/webrtc/VideoCodecStatus;", "frame", "Lorg/webrtc/VideoFrame;", "encodeInfo", "Lorg/webrtc/VideoEncoder$EncodeInfo;", "getImplementationName", "", "getScalingSettings", "Lorg/webrtc/VideoEncoder$ScalingSettings;", "initEncode", "settings", "callback", "Lorg/webrtc/VideoEncoder$Callback;", "release", "setRateAllocation", "allocation", "Lorg/webrtc/VideoEncoder$BitrateAllocation;", "frameRate", "", "Companion", "stream-webrtc-android_release"})
    private static final class StreamEncoderWrapper
    implements VideoEncoder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final VideoEncoder encoder;
        @NotNull
        private final ExecutorService executor;
        @Nullable
        private VideoEncoder.Settings streamSettings;
        @Nullable
        private static final String TAG = Reflection.getOrCreateKotlinClass(StreamEncoderWrapper.class).getSimpleName();

        public StreamEncoderWrapper(@NotNull VideoEncoder encoder) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            this.encoder = encoder;
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
            this.executor = executorService;
        }

        @Override
        @NotNull
        public VideoCodecStatus initEncode(@NotNull VideoEncoder.Settings settings, @Nullable VideoEncoder.Callback callback) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.streamSettings = settings;
            Future<VideoCodecStatus> future = this.executor.submit(() -> StreamEncoderWrapper.initEncode$lambda$0(this, settings, callback));
            VideoCodecStatus videoCodecStatus = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)videoCodecStatus), (String)"get(...)");
            return videoCodecStatus;
        }

        @Override
        @NotNull
        public VideoCodecStatus release() {
            Future<VideoCodecStatus> future = this.executor.submit(() -> StreamEncoderWrapper.release$lambda$1(this));
            VideoCodecStatus videoCodecStatus = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)videoCodecStatus), (String)"get(...)");
            return videoCodecStatus;
        }

        @Override
        @NotNull
        public VideoCodecStatus encode(@NotNull VideoFrame frame, @Nullable VideoEncoder.EncodeInfo encodeInfo) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Future<VideoCodecStatus> future = this.executor.submit(() -> StreamEncoderWrapper.encode$lambda$4(this, frame, encodeInfo));
            VideoCodecStatus videoCodecStatus = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)videoCodecStatus), (String)"get(...)");
            return videoCodecStatus;
        }

        @Override
        @NotNull
        public VideoCodecStatus setRateAllocation(@Nullable VideoEncoder.BitrateAllocation allocation, int frameRate) {
            Future<VideoCodecStatus> future = this.executor.submit(() -> StreamEncoderWrapper.setRateAllocation$lambda$5(this, allocation, frameRate));
            VideoCodecStatus videoCodecStatus = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)videoCodecStatus), (String)"get(...)");
            return videoCodecStatus;
        }

        @Override
        @NotNull
        public VideoEncoder.ScalingSettings getScalingSettings() {
            Future<VideoEncoder.ScalingSettings> future = this.executor.submit(() -> StreamEncoderWrapper.getScalingSettings$lambda$6(this));
            VideoEncoder.ScalingSettings scalingSettings = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)scalingSettings, (String)"get(...)");
            return scalingSettings;
        }

        @Override
        @NotNull
        public String getImplementationName() {
            Future<String> future = this.executor.submit(() -> StreamEncoderWrapper.getImplementationName$lambda$7(this));
            String string = future.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            return string;
        }

        private static final VideoCodecStatus initEncode$lambda$0(StreamEncoderWrapper this$0, VideoEncoder.Settings $settings, VideoEncoder.Callback $callback) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$settings, (String)"$settings");
            Logging.v(TAG, StringsKt.trimMargin$default((String)("initEncode() thread=" + Thread.currentThread().getName() + " [" + Thread.currentThread().getId() + "]\n                        |  encoder=" + this$0.encoder.getImplementationName() + "\n                        |  streamSettings:\n                        |    numberOfCores=" + $settings.numberOfCores + "\n                        |    width=" + $settings.width + "\n                        |    height=" + $settings.height + "\n                        |    startBitrate=" + $settings.startBitrate + "\n                        |    maxFramerate=" + $settings.maxFramerate + "\n                        |    automaticResizeOn=" + $settings.automaticResizeOn + "\n                        |    numberOfSimulcastStreams=" + $settings.numberOfSimulcastStreams + "\n                        |    lossNotification=" + $settings.capabilities.lossNotification + "\n            "), null, (int)1, null));
            return this$0.encoder.initEncode($settings, $callback);
        }

        private static final VideoCodecStatus release$lambda$1(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.release();
        }

        private static final VideoCodecStatus encode$lambda$4(StreamEncoderWrapper this$0, VideoFrame $frame, VideoEncoder.EncodeInfo $encodeInfo) {
            VideoCodecStatus videoCodecStatus;
            VideoCodecStatus videoCodecStatus2;
            VideoCodecStatus videoCodecStatus3;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$frame, (String)"$frame");
            VideoEncoder.Settings settings = this$0.streamSettings;
            if (settings != null) {
                VideoEncoder.Settings it = settings;
                boolean bl = false;
                if ($frame.getBuffer().getWidth() == it.width) {
                    videoCodecStatus3 = this$0.encoder.encode($frame, $encodeInfo);
                } else {
                    int originalWidth = $frame.getBuffer().getWidth();
                    int originalHeight = $frame.getBuffer().getHeight();
                    VideoFrame.Buffer scaledBuffer = $frame.getBuffer().cropAndScale(0, 0, originalWidth, originalHeight, it.width, it.height);
                    VideoFrame scaledFrame = new VideoFrame(scaledBuffer, $frame.getRotation(), $frame.getTimestampNs());
                    VideoCodecStatus result = this$0.encoder.encode(scaledFrame, $encodeInfo);
                    scaledBuffer.release();
                    videoCodecStatus3 = result;
                }
            } else {
                videoCodecStatus3 = videoCodecStatus2 = null;
            }
            if (videoCodecStatus2 == null) {
                StreamEncoderWrapper $this$encode_u24lambda_u244_u24lambda_u243 = this$0;
                boolean bl = false;
                videoCodecStatus = VideoCodecStatus.ERROR;
            } else {
                videoCodecStatus = videoCodecStatus2;
            }
            return videoCodecStatus;
        }

        private static final VideoCodecStatus setRateAllocation$lambda$5(StreamEncoderWrapper this$0, VideoEncoder.BitrateAllocation $allocation, int $frameRate) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.setRateAllocation($allocation, $frameRate);
        }

        private static final VideoEncoder.ScalingSettings getScalingSettings$lambda$6(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getScalingSettings();
        }

        private static final String getImplementationName$lambda$7(StreamEncoderWrapper this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            return this$0.encoder.getImplementationName();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/webrtc/SimulcastAlignedVideoEncoderFactory$StreamEncoderWrapper$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "stream-webrtc-android_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final String getTAG() {
                return TAG;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/webrtc/SimulcastAlignedVideoEncoderFactory$StreamEncoderWrapperFactory;", "Lorg/webrtc/VideoEncoderFactory;", "factory", "(Lorg/webrtc/VideoEncoderFactory;)V", "createEncoder", "Lorg/webrtc/VideoEncoder;", "videoCodecInfo", "Lorg/webrtc/VideoCodecInfo;", "getSupportedCodecs", "", "()[Lorg/webrtc/VideoCodecInfo;", "stream-webrtc-android_release"})
    private static final class StreamEncoderWrapperFactory
    implements VideoEncoderFactory {
        @NotNull
        private final VideoEncoderFactory factory;

        public StreamEncoderWrapperFactory(@NotNull VideoEncoderFactory factory) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            this.factory = factory;
        }

        @Override
        @Nullable
        public VideoEncoder createEncoder(@Nullable VideoCodecInfo videoCodecInfo) {
            VideoEncoder encoder = this.factory.createEncoder(videoCodecInfo);
            if (encoder == null) {
                return null;
            }
            return new StreamEncoderWrapper(encoder);
        }

        @Override
        @NotNull
        public VideoCodecInfo[] getSupportedCodecs() {
            VideoCodecInfo[] videoCodecInfoArray = this.factory.getSupportedCodecs();
            Intrinsics.checkNotNullExpressionValue((Object)videoCodecInfoArray, (String)"getSupportedCodecs(...)");
            return videoCodecInfoArray;
        }
    }
}

