/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.webrtc.SimulcastVideoEncoder;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoEncoderFactory;

public class SimulcastVideoEncoderFactory
implements VideoEncoderFactory {
    VideoEncoderFactory primary;
    VideoEncoderFactory fallback;

    static native List<VideoCodecInfo> nativeVP9Codecs();

    static native VideoCodecInfo nativeAV1Codec();

    public SimulcastVideoEncoderFactory(VideoEncoderFactory primary, VideoEncoderFactory fallback) {
        this.primary = primary;
        this.fallback = fallback;
    }

    @Override
    @Nullable
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        return new SimulcastVideoEncoder(this.primary, this.fallback, info);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.addAll(Arrays.asList(this.primary.getSupportedCodecs()));
        if (this.fallback != null) {
            codecs.addAll(Arrays.asList(this.fallback.getSupportedCodecs()));
        }
        codecs.addAll(SimulcastVideoEncoderFactory.nativeVP9Codecs());
        codecs.add(SimulcastVideoEncoderFactory.nativeAV1Codec());
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

