/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.strategy.constraints;

import io.getunleash.Constraint;
import io.getunleash.UnleashContext;
import io.getunleash.strategy.constraints.ConstraintOperator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class StringConstraintOperator
implements ConstraintOperator {
    private Locale comparisonLocale;

    public StringConstraintOperator(Locale comparisonLocale) {
        this.comparisonLocale = comparisonLocale;
    }

    @Override
    public boolean evaluate(Constraint constraint, UnleashContext context) {
        List<String> values = constraint.getValues();
        Optional<String> contextValue = context.getByName(constraint.getContextName());
        boolean caseInsensitive = constraint.isCaseInsensitive();
        switch (constraint.getOperator()) {
            case IN: {
                return this.isIn(values, contextValue, caseInsensitive);
            }
            case NOT_IN: {
                return !this.isIn(values, contextValue, caseInsensitive);
            }
            case STR_CONTAINS: {
                return this.contains(values, contextValue, caseInsensitive);
            }
            case STR_STARTS_WITH: {
                return this.startsWith(values, contextValue, caseInsensitive);
            }
            case STR_ENDS_WITH: {
                return this.endsWith(values, contextValue, caseInsensitive);
            }
        }
        return false;
    }

    private boolean endsWith(List<String> values, Optional<String> contextValue, boolean caseInsensitive) {
        return contextValue.map(c -> values.stream().anyMatch(v -> {
            if (caseInsensitive) {
                return c.toLowerCase(this.comparisonLocale).endsWith(v.toLowerCase(this.comparisonLocale));
            }
            return c.endsWith((String)v);
        })).orElse(false);
    }

    private boolean startsWith(List<String> values, Optional<String> contextValue, boolean caseInsensitive) {
        return contextValue.map(c -> values.stream().anyMatch(v -> {
            if (caseInsensitive) {
                return v.toLowerCase(this.comparisonLocale).startsWith(c.toLowerCase(this.comparisonLocale));
            }
            return c.startsWith((String)v);
        })).orElse(false);
    }

    private boolean contains(List<String> values, Optional<String> contextValue, boolean caseInsensitive) {
        return contextValue.map(c -> values.stream().anyMatch(v -> {
            if (caseInsensitive) {
                return c.toLowerCase(this.comparisonLocale).contains(v.toLowerCase(this.comparisonLocale));
            }
            return c.contains((CharSequence)v);
        })).orElse(false);
    }

    private boolean isIn(List<String> values, Optional<String> value, boolean caseInsensitive) {
        return value.map(v -> values.stream().anyMatch(c -> {
            if (caseInsensitive) {
                return c.equalsIgnoreCase((String)v);
            }
            return c.equals(v);
        })).orElse(false);
    }
}

