/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.metric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.metric.MetricSender;
import io.getunleash.util.AtomicLongSerializer;
import io.getunleash.util.DateTimeSerializer;
import io.getunleash.util.OkHttpClientConfigurer;
import io.getunleash.util.UnleashConfig;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttpMetricsSender
implements MetricSender {
    private final UnleashConfig config;
    private final MediaType JSON = Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8"));
    private final EventDispatcher eventDispatcher;
    private final OkHttpClient client;
    private final Gson gson;
    private final HttpUrl clientRegistrationUrl;
    private final HttpUrl clientMetricsUrl;

    public OkHttpMetricsSender(UnleashConfig config) {
        this.config = config;
        this.clientMetricsUrl = Objects.requireNonNull(HttpUrl.get((URL)config.getUnleashURLs().getClientMetricsURL()));
        this.clientRegistrationUrl = Objects.requireNonNull(HttpUrl.get((URL)config.getUnleashURLs().getClientRegisterURL()));
        this.eventDispatcher = new EventDispatcher(config);
        OkHttpClient.Builder builder = config.getProxy() != null ? new OkHttpClient.Builder().proxy(config.getProxy()) : new OkHttpClient.Builder();
        builder = builder.callTimeout(config.getSendMetricsConnectTimeout()).readTimeout(config.getSendMetricsReadTimeout());
        this.client = OkHttpClientConfigurer.configureInterceptor(config, builder.build());
        this.gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new DateTimeSerializer()).registerTypeAdapter(AtomicLong.class, (Object)new AtomicLongSerializer()).create();
    }

    @Override
    public void registerClient(ClientRegistration registration) {
        if (!this.config.isDisableMetrics()) {
            try {
                this.post(this.clientRegistrationUrl, registration);
                this.eventDispatcher.dispatch(registration);
            }
            catch (UnleashException ex) {
                this.eventDispatcher.dispatch(ex);
            }
        }
    }

    @Override
    public void sendMetrics(ClientMetrics metrics) {
        if (!this.config.isDisableMetrics()) {
            try {
                this.post(this.clientMetricsUrl, metrics);
                this.eventDispatcher.dispatch(metrics);
            }
            catch (UnleashException ex) {
                this.eventDispatcher.dispatch(ex);
            }
        }
    }

    private int post(HttpUrl url, Object o) {
        int n;
        block8: {
            RequestBody body = RequestBody.create((String)this.gson.toJson(o), (MediaType)this.JSON);
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = this.client.newCall(request).execute();
            try {
                n = response.code();
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioEx) {
                    throw new UnleashException("Could not post to Unleash API", ioEx);
                }
            }
            response.close();
        }
        return n;
    }
}

