/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import com.google.gson.JsonParseException;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.event.UnleashEvent;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.repository.BackupHandler;
import io.getunleash.repository.FeatureCollection;
import io.getunleash.repository.JsonFeatureParser;
import io.getunleash.repository.SegmentCollection;
import io.getunleash.repository.ToggleCollection;
import io.getunleash.util.UnleashConfig;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureBackupHandlerFile
implements BackupHandler<FeatureCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureBackupHandlerFile.class);
    private final String backupFile;
    private final EventDispatcher eventDispatcher;

    public FeatureBackupHandlerFile(UnleashConfig config) {
        this.backupFile = config.getBackupFile();
        this.eventDispatcher = new EventDispatcher(config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FeatureCollection read() {
        LOG.info("Unleash will try to load feature toggle states from temporary backup");
        try (FileReader reader = new FileReader(this.backupFile);){
            BufferedReader br = new BufferedReader(reader);
            FeatureCollection featureCollection2 = JsonFeatureParser.fromJson(br);
            this.eventDispatcher.dispatch(new FeatureBackupRead(featureCollection2));
            FeatureCollection featureCollection = featureCollection2;
            return featureCollection;
        }
        catch (FileNotFoundException e) {
            LOG.info(" Unleash could not find the backup-file '" + this.backupFile + "'. \nThis is expected behavior the first time unleash runs in a new environment.");
            return new FeatureCollection(new ToggleCollection(Collections.emptyList()), new SegmentCollection(Collections.emptyList()));
        }
        catch (JsonParseException | IOException | IllegalStateException e) {
            this.eventDispatcher.dispatch(new UnleashException("Failed to read backup file: " + this.backupFile, e));
        }
        return new FeatureCollection(new ToggleCollection(Collections.emptyList()), new SegmentCollection(Collections.emptyList()));
    }

    @Override
    public void write(FeatureCollection featureCollection) {
        try (FileWriter writer = new FileWriter(this.backupFile);){
            writer.write(JsonFeatureParser.toJsonString(featureCollection));
            this.eventDispatcher.dispatch(new FeatureBackupWritten(featureCollection));
        }
        catch (IOException e) {
            this.eventDispatcher.dispatch(new UnleashException("Unleash was unable to backup feature toggles to file: " + this.backupFile, e));
        }
    }

    private static class FeatureBackupWritten
    implements UnleashEvent {
        private final FeatureCollection featureCollection;

        private FeatureBackupWritten(FeatureCollection featureCollection) {
            this.featureCollection = featureCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.featuresBackedUp(this.featureCollection);
        }
    }

    private static class FeatureBackupRead
    implements UnleashEvent {
        private final FeatureCollection featureCollection;

        private FeatureBackupRead(FeatureCollection featureCollection) {
            this.featureCollection = featureCollection;
        }

        @Override
        public void publishTo(UnleashSubscriber unleashSubscriber) {
            unleashSubscriber.featuresBackupRestored(this.featureCollection);
        }
    }
}

