/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.metric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.getunleash.UnleashException;
import io.getunleash.event.EventDispatcher;
import io.getunleash.metric.ClientMetrics;
import io.getunleash.metric.ClientRegistration;
import io.getunleash.metric.MetricSender;
import io.getunleash.util.AtomicLongSerializer;
import io.getunleash.util.DateTimeSerializer;
import io.getunleash.util.UnleashConfig;
import io.getunleash.util.UnleashURLs;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultHttpMetricsSender
implements MetricSender {
    private static final int CONNECT_TIMEOUT = 1000;
    private final Gson gson;
    private final EventDispatcher eventDispatcher;
    private UnleashConfig unleashConfig;
    private final URL clientRegistrationURL;
    private final URL clientMetricsURL;

    public DefaultHttpMetricsSender(UnleashConfig unleashConfig) {
        this.unleashConfig = unleashConfig;
        this.eventDispatcher = new EventDispatcher(unleashConfig);
        UnleashURLs urls = unleashConfig.getUnleashURLs();
        this.clientMetricsURL = urls.getClientMetricsURL();
        this.clientRegistrationURL = urls.getClientRegisterURL();
        this.gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new DateTimeSerializer()).registerTypeAdapter(AtomicLong.class, (Object)new AtomicLongSerializer()).create();
    }

    @Override
    public int registerClient(ClientRegistration registration) {
        if (!this.unleashConfig.isDisableMetrics()) {
            try {
                int statusCode = this.post(this.clientRegistrationURL, registration);
                this.eventDispatcher.dispatch(registration);
                return statusCode;
            }
            catch (UnleashException ex) {
                this.eventDispatcher.dispatch(ex);
                return -1;
            }
        }
        return -1;
    }

    @Override
    public int sendMetrics(ClientMetrics metrics) {
        if (!this.unleashConfig.isDisableMetrics()) {
            try {
                int statusCode = this.post(this.clientMetricsURL, metrics);
                this.eventDispatcher.dispatch(metrics);
                return statusCode;
            }
            catch (UnleashException ex) {
                this.eventDispatcher.dispatch(ex);
                return -1;
            }
        }
        return -1;
    }

    private int post(URL url, Object o) throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = this.unleashConfig.getProxy() != null ? (HttpURLConnection)url.openConnection(this.unleashConfig.getProxy()) : (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout((int)this.unleashConfig.getSendMetricsConnectTimeout().toMillis());
            connection.setReadTimeout((int)this.unleashConfig.getSendMetricsReadTimeout().toMillis());
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            UnleashConfig.setRequestProperties(connection, this.unleashConfig);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(connection.getOutputStream());
            this.gson.toJson(o, (Appendable)wr);
            wr.flush();
            wr.close();
            connection.connect();
            int n = connection.getResponseCode();
            return n;
        }
        catch (IOException e) {
            throw new UnleashException("Could not post to Unleash API", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

