/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.sun.jna.Native;
import io.getunleash.engine.CamelToSnakeMapper;
import io.getunleash.engine.UnleashFFI;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;

class NativeLoader {
    static final UnleashFFI NATIVE_INTERFACE = NativeLoader.loadLibrary();

    NativeLoader() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static UnleashFFI loadLibrary() {
        String libName;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("mac")) {
            libName = arch.contains("aarch64") || arch.contains("arm64") ? "libyggdrasilffi_arm64.dylib" : "libyggdrasilffi_x86_64.dylib";
        } else if (os.contains("win")) {
            if (arch.equals("x86_64") || arch.contains("amd64")) {
                libName = "yggdrasilffi_x86_64.dll";
            } else if (arch.equals("x86") || arch.equals("i386") || arch.equals("i686")) {
                libName = "yggdrasilffi_i686.dll";
            } else {
                if (!arch.contains("arm64")) throw new UnsupportedOperationException("Unsupported architecture on Windows: " + arch);
                libName = "yggdrasilffi_arm64.dll";
            }
        } else {
            if (!os.contains("linux")) throw new UnsupportedOperationException("Unsupported operating system: " + os + ", architecture: " + arch);
            libName = NativeLoader.isMusl() ? (arch.contains("aarch64") ? "libyggdrasilffi_arm64-musl.so" : "libyggdrasilffi_x86_64-musl.so") : (arch.contains("aarch64") || arch.contains("arm64") ? "libyggdrasilffi_arm64.so" : "libyggdrasilffi_x86_64.so");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("function-mapper", new CamelToSnakeMapper());
        options.put("string-encoding", "UTF-8");
        try {
            Path tempLib = NativeLoader.extractLibraryFromJar(libName);
            System.load(tempLib.toAbsolutePath().toString());
            return (UnleashFFI)Native.load((String)tempLib.toAbsolutePath().toString(), UnleashFFI.class, options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load native library", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isMusl() {
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/self/maps"));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!line.contains("musl"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.err.println("Warning: Failed to read /proc/self/maps, assuming this is not a musl system: " + e.getMessage());
        }
        return false;
    }

    private static Path extractLibraryFromJar(String libName) throws IOException {
        Path tempFile = Files.createTempFile("lib", libName, new FileAttribute[0]);
        try (InputStream in = UnleashFFI.class.getResourceAsStream("/native/" + libName);
             OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            int readBytes;
            if (in == null) {
                throw new FileNotFoundException("File " + libName + " was not found inside JAR.");
            }
            byte[] buffer = new byte[1024];
            while ((readBytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
            }
        }
        return tempFile;
    }
}

