/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.getunleash.engine.Context;
import io.getunleash.engine.IStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomStrategiesEvaluator {
    private static final Logger log = LoggerFactory.getLogger(CustomStrategiesEvaluator.class);
    static final Map<String, Boolean> EMPTY_STRATEGY_RESULTS = new HashMap<String, Boolean>();
    private final Map<String, IStrategy> registeredStrategies;
    private final Set<String> builtinStrategies;
    private final IStrategy fallbackStrategy;
    private final ObjectMapper mapper;
    private Map<String, List<MappedStrategy>> featureStrategies = new HashMap<String, List<MappedStrategy>>();

    public CustomStrategiesEvaluator(Stream<IStrategy> customStrategies, Set<String> builtinStrategies) {
        this(customStrategies, null, builtinStrategies);
    }

    public CustomStrategiesEvaluator(Stream<IStrategy> customStrategies, IStrategy fallbackStrategy, Set<String> builtinStrategies) {
        this.builtinStrategies = builtinStrategies;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.registeredStrategies = customStrategies.collect(Collectors.toMap(IStrategy::getName, Function.identity(), (a, b) -> a));
        this.fallbackStrategy = fallbackStrategy;
    }

    public void loadStrategiesFor(String toggles) {
        if (this.registeredStrategies.isEmpty() && this.fallbackStrategy == null) {
            return;
        }
        if (toggles == null || toggles.isEmpty()) {
            return;
        }
        try {
            VersionedFeatures wrapper = (VersionedFeatures)this.mapper.readValue(toggles, (TypeReference)new TypeReference<VersionedFeatures>(){});
            if (wrapper.features != null) {
                this.featureStrategies = wrapper.features.stream().collect(Collectors.toMap(feature -> ((FeatureDefinition)feature).name, this::getFeatureStrategies));
            }
        }
        catch (JsonProcessingException e) {
            log.warn("Error processing features. This means custom strategies will return false every time they're used", (Throwable)e);
        }
    }

    List<MappedStrategy> getFeatureStrategies(FeatureDefinition feature) {
        ArrayList<MappedStrategy> mappedStrategies = new ArrayList<MappedStrategy>();
        int index = 1;
        for (StrategyDefinition strategyDefinition : feature.strategies) {
            if (this.builtinStrategies.contains(strategyDefinition.name)) continue;
            IStrategy impl = Optional.ofNullable(this.registeredStrategies.get(strategyDefinition.name)).orElseGet(() -> this.alwaysFalseStrategy(strategyDefinition.name));
            mappedStrategies.add(new MappedStrategy("customStrategy" + index++, impl, strategyDefinition));
        }
        if (this.fallbackStrategy != null) {
            mappedStrategies.add(new MappedStrategy("customStrategy" + index, this.fallbackStrategy, new StrategyDefinition("fallback", Collections.emptyMap())));
        }
        return mappedStrategies;
    }

    public Map<String, Boolean> eval(String name, Context context) {
        List<MappedStrategy> mappedStrategies = this.featureStrategies.get(name);
        if (mappedStrategies == null || mappedStrategies.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, Boolean> results = mappedStrategies.stream().collect(Collectors.toMap(mappedStrategy -> ((MappedStrategy)mappedStrategy).resultName, mappedStrategy -> CustomStrategiesEvaluator.tryIsEnabled(context, mappedStrategy).orElse(false)));
        return results;
    }

    private static Optional<Boolean> tryIsEnabled(Context context, MappedStrategy mappedStrategy) {
        try {
            return Optional.of(mappedStrategy.implementation.isEnabled(mappedStrategy.strategyDefinition.parameters, context));
        }
        catch (Exception e) {
            log.warn("Error evaluating custom strategy {}", (Object)mappedStrategy.strategyDefinition.name, (Object)e);
            return Optional.empty();
        }
    }

    private IStrategy alwaysFalseStrategy(final String name) {
        log.warn("Custom strategy {} not found. This means it will always return false", (Object)name);
        return new IStrategy(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public boolean isEnabled(Map<String, String> parameters, Context context) {
                return false;
            }
        };
    }

    private static class VersionedFeatures {
        private final List<FeatureDefinition> features;

        @JsonCreator
        private VersionedFeatures(@JsonProperty(value="features") List<FeatureDefinition> features) {
            this.features = features;
        }
    }

    static class FeatureDefinition {
        private final String name;
        private final List<StrategyDefinition> strategies;

        @JsonCreator
        FeatureDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="strategies") List<StrategyDefinition> strategies) {
            this.name = name;
            this.strategies = strategies;
        }
    }

    static class StrategyDefinition {
        private final String name;
        private final Map<String, String> parameters;

        @JsonCreator
        StrategyDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="parameters") Map<String, String> parameters) {
            this.name = name;
            this.parameters = parameters;
        }
    }

    static class MappedStrategy {
        private final String resultName;
        private final IStrategy implementation;
        private final StrategyDefinition strategyDefinition;

        private MappedStrategy(String resultName, IStrategy implementation, StrategyDefinition strategyDefinition) {
            this.resultName = resultName;
            this.implementation = implementation;
            this.strategyDefinition = strategyDefinition;
        }
    }
}

