package io.getunleash.wasm;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.runtime.Machine;
import java.io.IOException;
import java.io.UncheckedIOException;
import com.dylibso.chicory.wasm.Parser;
import com.dylibso.chicory.wasm.WasmModule;
import java.io.InputStream;

public final class YggdrasilModule {

    private YggdrasilModule() {
    }

    public static Machine create(Instance instance) {
        return new io.getunleash.wasm.YggdrasilMachine(instance);
    }

    public static WasmModule load() {
        try (InputStream in = YggdrasilModule.class.getResourceAsStream("Yggdrasil.meta")) {
            return Parser.parse(in);
        } catch (IOException e) {
            throw new UncheckedIOException("Failed to load AOT WASM module", e);
        }
    }
}
