/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.google.flatbuffers.FlatBufferBuilder;
import io.getunleash.engine.Context;
import io.getunleash.engine.CustomStrategiesEvaluator;
import io.getunleash.engine.FeatureCount;
import io.getunleash.engine.FeatureDef;
import io.getunleash.engine.IStrategy;
import io.getunleash.engine.MetricsBucket;
import io.getunleash.engine.NativeInterface;
import io.getunleash.engine.Payload;
import io.getunleash.engine.VariantDef;
import io.getunleash.engine.WasmInterface;
import io.getunleash.engine.WasmResponse;
import io.getunleash.engine.YggdrasilInvalidInputException;
import java.lang.ref.Cleaner;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import messaging.BuiltInStrategies;
import messaging.ContextMessage;
import messaging.FeatureDefs;
import messaging.MetricsResponse;
import messaging.PropertyEntry;
import messaging.Response;
import messaging.ToggleEntry;
import messaging.ToggleStats;
import messaging.Variant;
import messaging.VariantEntry;
import messaging.VariantPayload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnleashEngine {
    private static final Logger log = LoggerFactory.getLogger(UnleashEngine.class);
    private static final Cleaner cleaner = Cleaner.create();
    private final NativeInterface nativeInterface;
    private final int enginePointer;
    private final CustomStrategiesEvaluator customStrategiesEvaluator;

    public UnleashEngine() {
        this(null, null, null);
    }

    public UnleashEngine(List<IStrategy> customStrategies) {
        this(customStrategies, null, null);
    }

    public UnleashEngine(List<IStrategy> customStrategies, IStrategy fallbackStrategy) {
        this(customStrategies, fallbackStrategy, null);
    }

    UnleashEngine(List<IStrategy> customStrategies, IStrategy fallbackStrategy, NativeInterface nativeInterface) {
        if (customStrategies != null && !customStrategies.isEmpty()) {
            List<String> builtInStrategies = UnleashEngine.getBuiltInStrategies();
            this.customStrategiesEvaluator = new CustomStrategiesEvaluator(customStrategies.stream(), fallbackStrategy, new HashSet<String>(builtInStrategies));
        } else {
            this.customStrategiesEvaluator = new CustomStrategiesEvaluator(Stream.empty(), fallbackStrategy, new HashSet<String>());
        }
        this.nativeInterface = nativeInterface != null ? nativeInterface : new WasmInterface();
        Instant now = Instant.now();
        int enginePtr = this.nativeInterface.newEngine(now.toEpochMilli());
        if (enginePtr <= 0) {
            throw new IllegalStateException("Failed to create Unleash engine (invalid pointer): " + enginePtr);
        }
        this.enginePointer = enginePtr;
        NativeInterface wasmHook = this.nativeInterface;
        cleaner.register(this, () -> wasmHook.freeEngine(enginePtr));
    }

    private static String getRuntimeHostname() {
        String hostname = System.getProperty("hostname");
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                hostname = "undefined";
            }
        }
        return hostname;
    }

    private static int[] buildProperties(FlatBufferBuilder builder, Map<String, String> properties) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(properties.entrySet());
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (Map.Entry entry : entries) {
            if (entry.getValue() == null) continue;
            int keyOffset = builder.createString((CharSequence)entry.getKey());
            int valueOffset = builder.createString((CharSequence)entry.getValue());
            int propOffset = PropertyEntry.createPropertyEntry(builder, keyOffset, valueOffset);
            offsets.add(propOffset);
        }
        return offsets.stream().mapToInt(Integer::intValue).toArray();
    }

    private static int[] buildCustomStrategyResults(FlatBufferBuilder builder, Map<String, Boolean> results) {
        ArrayList<Map.Entry<String, Boolean>> entries = new ArrayList<Map.Entry<String, Boolean>>(results.entrySet());
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        for (Map.Entry entry : entries) {
            if (entry.getValue() == null) continue;
            int keyOffset = builder.createString((CharSequence)entry.getKey());
            int propOffset = PropertyEntry.createPropertyEntry(builder, keyOffset, (Boolean)entry.getValue() != false ? 1 : 0);
            offsets.add(propOffset);
        }
        return offsets.stream().mapToInt(Integer::intValue).toArray();
    }

    private static byte[] buildMessage(String toggleName, Context context, Map<String, Boolean> customStrategyResults) {
        FlatBufferBuilder builder = new FlatBufferBuilder(1024);
        int toggleNameOffset = builder.createString((CharSequence)toggleName);
        int userIdOffset = context.getUserId() != null ? builder.createString((CharSequence)context.getUserId()) : 0;
        int sessionIdOffset = context.getSessionId() != null ? builder.createString((CharSequence)context.getSessionId()) : 0;
        int appNameOffset = context.getAppName() != null ? builder.createString((CharSequence)context.getAppName()) : 0;
        int remoteAddressOffset = context.getRemoteAddress() != null ? builder.createString((CharSequence)context.getRemoteAddress()) : 0;
        String currentTime = context.getCurrentTime() != null ? context.getCurrentTime() : Instant.now().toString();
        int currentTimeOffset = builder.createString((CharSequence)currentTime);
        int environmentOffset = context.getEnvironment() != null ? builder.createString((CharSequence)context.getEnvironment()) : 0;
        int[] propertyOffsets = UnleashEngine.buildProperties(builder, context.getProperties());
        int[] customStrategyResultsOffsets = UnleashEngine.buildCustomStrategyResults(builder, customStrategyResults);
        String runtimeHostname = UnleashEngine.getRuntimeHostname();
        int runtimeHostnameOffset = runtimeHostname != null ? builder.createString((CharSequence)runtimeHostname) : builder.createString((CharSequence)UnleashEngine.getRuntimeHostname());
        int propsVec = ContextMessage.createPropertiesVector(builder, propertyOffsets);
        int customStrategyResultsVec = ContextMessage.createCustomStrategiesResultsVector(builder, customStrategyResultsOffsets);
        ContextMessage.startContextMessage(builder);
        if (userIdOffset != 0) {
            ContextMessage.addUserId(builder, userIdOffset);
        }
        if (sessionIdOffset != 0) {
            ContextMessage.addSessionId(builder, sessionIdOffset);
        }
        if (appNameOffset != 0) {
            ContextMessage.addAppName(builder, appNameOffset);
        }
        if (environmentOffset != 0) {
            ContextMessage.addEnvironment(builder, environmentOffset);
        }
        if (remoteAddressOffset != 0) {
            ContextMessage.addRemoteAddress(builder, remoteAddressOffset);
        }
        if (runtimeHostnameOffset != 0) {
            ContextMessage.addRuntimeHostname(builder, runtimeHostnameOffset);
        }
        ContextMessage.addCurrentTime(builder, currentTimeOffset);
        ContextMessage.addToggleName(builder, toggleNameOffset);
        if (propertyOffsets.length > 0) {
            ContextMessage.addProperties(builder, propsVec);
        }
        if (customStrategyResultsOffsets.length > 0) {
            ContextMessage.addCustomStrategiesResults(builder, customStrategyResultsVec);
        }
        int ctx = ContextMessage.endContextMessage(builder);
        builder.finish(ctx);
        return builder.sizedByteArray();
    }

    public void takeState(String clientFeatures) throws YggdrasilInvalidInputException {
        try {
            this.customStrategiesEvaluator.loadStrategiesFor(clientFeatures);
            byte[] messageBytes = clientFeatures.getBytes(StandardCharsets.UTF_8);
            this.nativeInterface.takeState(this.enginePointer, messageBytes);
        }
        catch (RuntimeException e) {
            throw new YggdrasilInvalidInputException("Failed to take state:", e);
        }
    }

    public String getState() {
        return this.nativeInterface.getState(this.enginePointer);
    }

    public List<FeatureDef> listKnownToggles() {
        try {
            FeatureDefs featureDefs = this.nativeInterface.listKnownToggles(this.enginePointer);
            ArrayList<FeatureDef> defs = new ArrayList<FeatureDef>(featureDefs.itemsLength());
            for (int i = 0; i < featureDefs.itemsLength(); ++i) {
                FeatureDef featureDef = new FeatureDef(featureDefs.items(i).name(), featureDefs.items(i).type(), featureDefs.items(i).project(), featureDefs.items(i).enabled());
                defs.add(featureDef);
            }
            return defs;
        }
        catch (RuntimeException e) {
            log.warn("Unable to list known toggles, will return empty list", (Throwable)e);
            return new ArrayList<FeatureDef>();
        }
    }

    public WasmResponse<Boolean> isEnabled(String toggleName, Context context) throws YggdrasilInvalidInputException {
        try {
            Map<String, Boolean> strategyResults = this.customStrategiesEvaluator.eval(toggleName, context);
            byte[] contextBytes = UnleashEngine.buildMessage(toggleName, context, strategyResults);
            Response response = this.nativeInterface.checkEnabled(this.enginePointer, contextBytes);
            if (response.error() != null) {
                String error = response.error();
                throw new YggdrasilInvalidInputException(error);
            }
            if (response.hasEnabled()) {
                return new WasmResponse<Boolean>(response.impressionData(), response.enabled());
            }
            return new WasmResponse<Object>(response.impressionData(), null);
        }
        catch (RuntimeException e) {
            log.warn("Could not check if toggle is enabled: {}", (Object)e.getMessage(), (Object)e);
            return new WasmResponse<Object>(false, null);
        }
    }

    public WasmResponse<VariantDef> getVariant(String toggleName, Context context) throws YggdrasilInvalidInputException {
        try {
            Map<String, Boolean> strategyResults = this.customStrategiesEvaluator.eval(toggleName, context);
            byte[] contextBytes = UnleashEngine.buildMessage(toggleName, context, strategyResults);
            Variant variant = this.nativeInterface.checkVariant(this.enginePointer, contextBytes);
            if (variant.name() != null) {
                Payload payload = null;
                VariantPayload variantPayload = variant.payload();
                if (variantPayload != null) {
                    payload = new Payload();
                    payload.setType(variant.payload().payloadType());
                    payload.setValue(variant.payload().value());
                }
                if (variant.error() != null) {
                    String error = variant.error();
                    throw new YggdrasilInvalidInputException(error);
                }
                return new WasmResponse<VariantDef>(variant.impressionData(), new VariantDef(variant.name(), payload, variant.enabled(), variant.featureEnabled()));
            }
            return new WasmResponse<Object>(false, null);
        }
        catch (RuntimeException e) {
            log.warn("Could not get variant for toggle '{}': {}", new Object[]{toggleName, e.getMessage(), e});
            return new WasmResponse<Object>(false, null);
        }
    }

    public MetricsBucket getMetrics() {
        try {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            MetricsResponse response = this.nativeInterface.getMetrics(this.enginePointer, now);
            if (response.togglesVector() == null) {
                return null;
            }
            HashMap<String, FeatureCount> toggles = new HashMap<String, FeatureCount>();
            for (int i = 0; i < response.togglesLength(); ++i) {
                ToggleEntry toggleEntry = response.toggles(i);
                ToggleStats stats = toggleEntry.value();
                HashMap<String, Long> variants = new HashMap<String, Long>();
                for (int j = 0; j < stats.variantsLength(); ++j) {
                    VariantEntry variant = stats.variants(j);
                    variants.put(variant.key(), variant.value());
                }
                FeatureCount featureCount = new FeatureCount(stats.yes(), stats.no(), variants);
                toggles.put(toggleEntry.key(), featureCount);
            }
            Instant startInstant = Instant.ofEpochMilli(response.start());
            Instant stopInstant = Instant.ofEpochMilli(response.stop());
            return new MetricsBucket(startInstant, stopInstant, toggles);
        }
        catch (RuntimeException e) {
            log.warn("Error retrieving metrics: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    public static String getCoreVersion() {
        return WasmInterface.getCoreVersion();
    }

    public static List<String> getBuiltInStrategies() {
        BuiltInStrategies builtInStrategiesMessage = WasmInterface.getBuiltInStrategies();
        ArrayList<String> builtInStrategies = new ArrayList<String>(builtInStrategiesMessage.valuesLength());
        for (int i = 0; i < builtInStrategiesMessage.valuesLength(); ++i) {
            String strategyName = builtInStrategiesMessage.values(i);
            builtInStrategies.add(strategyName);
        }
        return builtInStrategies;
    }
}

