/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.engine;

import com.dylibso.chicory.runtime.ByteBufferMemory;
import com.dylibso.chicory.runtime.ExportFunction;
import com.dylibso.chicory.runtime.HostFunction;
import com.dylibso.chicory.runtime.ImportFunction;
import com.dylibso.chicory.runtime.ImportValues;
import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.WasmModule;
import com.dylibso.chicory.wasm.types.FunctionType;
import com.dylibso.chicory.wasm.types.ValType;
import io.getunleash.engine.NativeInterface;
import io.getunleash.wasm.Yggdrasil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.Function;
import messaging.BuiltInStrategies;
import messaging.CoreVersion;
import messaging.FeatureDefs;
import messaging.MetricsResponse;
import messaging.Response;
import messaging.Variant;

public class WasmInterface
implements NativeInterface {
    private static final Instance instance;
    private static final ExportFunction newEngine;
    private static final ExportFunction freeEngine;
    private static final ExportFunction alloc;
    private static final ExportFunction dealloc;
    private static final ExportFunction takeState;
    private static final ExportFunction getState;
    private static final ExportFunction checkEnabled;
    private static final ExportFunction checkVariant;
    private static final ExportFunction getMetrics;
    private static final ExportFunction deallocResponseBuffer;
    private static final ExportFunction getLogBufferPtr;
    private static final ExportFunction listKnownToggles;
    private static final ExportFunction getCoreVersion;
    private static final ExportFunction getBuiltInStrategies;
    private static final ExportFunction freeCString;
    private static final Object engineLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newEngine(long timestamp) {
        Object object = engineLock;
        synchronized (object) {
            return (int)newEngine.apply(new long[]{timestamp})[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeEngine(int ptr) {
        Object object = engineLock;
        synchronized (object) {
            freeEngine.apply(new long[]{ptr});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeState(int enginePtr, byte[] messageBytes) {
        Object object = engineLock;
        synchronized (object) {
            int len = messageBytes.length;
            int ptr = (int)alloc.apply(new long[]{len})[0];
            instance.memory().write(ptr, messageBytes);
            takeState.apply(new long[]{enginePtr, ptr, len});
            dealloc.apply(new long[]{ptr, len});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getState(int enginePtr) {
        Object object = engineLock;
        synchronized (object) {
            String result;
            int ptr = (int)getState.apply(new long[]{enginePtr})[0];
            if (ptr == 0) {
                return null;
            }
            try {
                result = instance.memory().readCString(ptr);
            }
            catch (Throwable throwable) {
                freeCString.apply(new long[]{ptr});
                throw throwable;
            }
            freeCString.apply(new long[]{ptr});
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response checkEnabled(int enginePtr, byte[] contextBytes) {
        Object object = engineLock;
        synchronized (object) {
            int contextPtr = (int)alloc.apply(new long[]{contextBytes.length})[0];
            instance.memory().write(contextPtr, contextBytes);
            long response = checkEnabled.apply(new long[]{enginePtr, contextPtr, contextBytes.length})[0];
            Response responseObj = WasmInterface.derefWasmPointer(response, Response::getRootAsResponse);
            dealloc.apply(new long[]{contextPtr, contextBytes.length});
            return responseObj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variant checkVariant(int enginePtr, byte[] contextBytes) {
        Object object = engineLock;
        synchronized (object) {
            int contextPtr = (int)alloc.apply(new long[]{contextBytes.length})[0];
            instance.memory().write(contextPtr, contextBytes);
            long response = checkVariant.apply(new long[]{enginePtr, contextPtr, contextBytes.length})[0];
            Variant variant = WasmInterface.derefWasmPointer(response, Variant::getRootAsVariant);
            dealloc.apply(new long[]{contextPtr, contextBytes.length});
            return variant;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetricsResponse getMetrics(int enginePtr, ZonedDateTime timestamp) {
        Object object = engineLock;
        synchronized (object) {
            long packed = getMetrics.apply(new long[]{enginePtr, timestamp.toInstant().toEpochMilli()})[0];
            return WasmInterface.derefWasmPointer(packed, MetricsResponse::getRootAsMetricsResponse);
        }
    }

    @Override
    public int getLogBufferPtr() {
        long[] result = getLogBufferPtr.apply(new long[0]);
        return (int)result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureDefs listKnownToggles(int enginePtr) {
        Object object = engineLock;
        synchronized (object) {
            long packed = listKnownToggles.apply(new long[]{enginePtr})[0];
            return WasmInterface.derefWasmPointer(packed, FeatureDefs::getRootAsFeatureDefs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCoreVersion() {
        Object object = engineLock;
        synchronized (object) {
            long packed = getCoreVersion.apply(new long[0])[0];
            CoreVersion version = WasmInterface.derefWasmPointer(packed, CoreVersion::getRootAsCoreVersion);
            return version.version();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuiltInStrategies getBuiltInStrategies() {
        Object object = engineLock;
        synchronized (object) {
            long packed = getBuiltInStrategies.apply(new long[0])[0];
            return WasmInterface.derefWasmPointer(packed, BuiltInStrategies::getRootAsBuiltInStrategies);
        }
    }

    private static <T> T derefWasmPointer(long packed, Function<ByteBuffer, T> decoder) {
        int ptr = (int)(packed & 0xFFFFFFFFL);
        int len = (int)(packed >>> 32);
        byte[] bytes = instance.memory().readBytes(ptr, len);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        T response = decoder.apply(buf);
        deallocResponseBuffer.apply(new long[]{ptr, len});
        return response;
    }

    private void readLog() {
        int start = this.getLogBufferPtr();
        String msg = instance.memory().readCString(start);
        if (msg != null && !msg.isEmpty()) {
            System.out.println("DebugLog: " + msg);
        }
    }

    static {
        engineLock = new Object();
        FunctionType fillRandomFunctionType = FunctionType.of(List.of(ValType.I32, ValType.I32), List.of(ValType.I32));
        ImportValues imports = ImportValues.builder().addFunction(new ImportFunction[]{new HostFunction("env", "fill_random", fillRandomFunctionType, (instance, args) -> {
            int ptr = (int)args[0];
            int len = (int)args[1];
            if (len <= 0 || ptr < 0) {
                return new long[]{1L};
            }
            byte[] randomBytes = new byte[len];
            new SecureRandom().nextBytes(randomBytes);
            instance.memory().write(ptr, randomBytes);
            return new long[]{0L};
        })}).build();
        WasmInterface.instance = Instance.builder((WasmModule)Yggdrasil.load()).withMachineFactory(Yggdrasil::create).withImportValues(imports).withMemoryFactory(ByteBufferMemory::new).build();
        alloc = WasmInterface.instance.export("local_alloc");
        dealloc = WasmInterface.instance.export("local_dealloc");
        takeState = WasmInterface.instance.export("take_state");
        getState = WasmInterface.instance.export("get_state");
        checkEnabled = WasmInterface.instance.export("check_enabled");
        checkVariant = WasmInterface.instance.export("check_variant");
        getMetrics = WasmInterface.instance.export("get_metrics");
        deallocResponseBuffer = WasmInterface.instance.export("dealloc_response_buffer");
        getLogBufferPtr = WasmInterface.instance.export("get_log_buffer_ptr");
        listKnownToggles = WasmInterface.instance.export("list_known_toggles");
        getCoreVersion = WasmInterface.instance.export("get_core_version");
        getBuiltInStrategies = WasmInterface.instance.export("get_built_in_strategies");
        newEngine = WasmInterface.instance.export("new_engine");
        freeEngine = WasmInterface.instance.export("free_engine");
        freeCString = WasmInterface.instance.export("free_cstring");
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }
}

