/*
 * Decompiled with CFR 0.152.
 */
package com.mos.secure.ext.aspect;

import cn.hutool.core.util.StrUtil;
import com.mos.secure.ext.annotations.Desensitization;
import com.mos.secure.ext.annotations.DesensitizationProp;
import com.mos.secure.ext.config.SensitiveProp;
import com.mos.secure.ext.util.MosDesensitizedUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SensitiveAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveAspect.class);
    @Resource
    private SensitiveProp sensitiveProp;

    @Pointcut(value="@annotation(com.mos.secure.ext.annotations.Desensitization)")
    public void getPoint() {
    }

    @Around(value="getPoint()")
    public Object sensitiveClass(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.sensitiveProp.getEnable().booleanValue()) {
            return joinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Desensitization desensitization = method.getAnnotation(Desensitization.class);
        if (desensitization == null || !desensitization.enable()) {
            return joinPoint.proceed();
        }
        return this.sensitiveFormat(joinPoint);
    }

    public Object sensitiveFormat(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj = joinPoint.proceed();
        this.dealNode(obj);
        return obj;
    }

    private void dealList(Object o) throws IllegalAccessException {
        List list = (List)o;
        for (Object obj : list) {
            this.dealNode(obj);
        }
    }

    public void dealNode(Object o) throws IllegalAccessException {
        Field[] fields;
        if (o instanceof List) {
            this.dealList(o);
            return;
        }
        if (o == null) {
            return;
        }
        boolean needDepthDeal = this.sensitiveProp.getDepth() != false && !StrUtil.isBlankIfStr((Object)this.sensitiveProp.getPackages());
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            DesensitizationProp desensitizationProp;
            field.setAccessible(true);
            String type = field.getGenericType().toString();
            Object fieldValueObj = field.get(o);
            if (fieldValueObj instanceof List) {
                this.dealList(fieldValueObj);
            }
            if (needDepthDeal && this.containType(type).booleanValue()) {
                this.dealNode(fieldValueObj);
            }
            if ((desensitizationProp = field.getAnnotation(DesensitizationProp.class)) == null) continue;
            String v = MosDesensitizedUtil.desensitizeData(fieldValueObj, desensitizationProp);
            field.set(o, v);
        }
    }

    private Boolean containType(String type) {
        String[] scanPackages = this.sensitiveProp.getPackages().split(",");
        boolean isContainType = false;
        for (String scanPackage : scanPackages) {
            if (!type.contains(scanPackage)) continue;
            isContainType = true;
            break;
        }
        return isContainType;
    }
}

