/*
 * Decompiled with CFR 0.152.
 */
package com.mos.secure.ext.util;

import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.StrUtil;
import com.mos.secure.ext.annotations.DesensitizationProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MosDesensitizedUtil {
    private static final Logger log = LoggerFactory.getLogger(MosDesensitizedUtil.class);

    public static String desensitizeData(Object obj, DesensitizationProp desensitizationProp) {
        if (obj == null || desensitizationProp == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            return String.valueOf(obj);
        }
        return MosDesensitizedUtil.formatValue(obj.toString(), desensitizationProp);
    }

    private static String formatValue(String value, DesensitizationProp desensitizationProp) {
        switch (desensitizationProp.value()) {
            case ADDRESS: {
                value = DesensitizedUtil.address((String)value, (int)Math.min(value.length(), 3));
                break;
            }
            case ID_CARD: {
                value = DesensitizedUtil.idCardNum((String)value, (int)6, (int)4);
                break;
            }
            case MOBILE_PHONE: {
                value = DesensitizedUtil.mobilePhone((String)value);
                break;
            }
            case EMAIL: {
                value = DesensitizedUtil.email((String)value);
                break;
            }
            case BANK_CARD: {
                value = DesensitizedUtil.bankCard((String)value);
                break;
            }
            case PASSWORD: {
                value = DesensitizedUtil.password((String)value);
                break;
            }
            case CHINESE_NAME: {
                value = DesensitizedUtil.chineseName((String)value);
                break;
            }
            case CUSTOM: {
                value = StrUtil.hide((CharSequence)value, (int)desensitizationProp.preLength(), (int)Math.min(value.length(), desensitizationProp.sufLength()));
            }
        }
        return value;
    }
}

