/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.chemors.secure.ext.aspect;

import io.gitee.chemors.secure.ext.annotations.Desensitization;
import io.gitee.chemors.secure.ext.config.SensitiveProp;
import io.gitee.chemors.secure.ext.util.FieldSensitiveUtil;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SensitiveAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveAspect.class);
    @Resource
    private SensitiveProp sensitiveProp;

    @Pointcut(value="@annotation(io.gitee.chemors.secure.ext.annotations.Desensitization)")
    public void getPoint() {
    }

    @Around(value="getPoint()")
    public Object sensitiveClass(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.sensitiveProp.getEnable().booleanValue()) {
            return joinPoint.proceed();
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Desensitization desensitization = method.getAnnotation(Desensitization.class);
        if (desensitization == null || !desensitization.enable()) {
            return joinPoint.proceed();
        }
        return this.sensitiveFormat(joinPoint);
    }

    public Object sensitiveFormat(ProceedingJoinPoint joinPoint) throws Throwable {
        Object obj = joinPoint.proceed();
        FieldSensitiveUtil.dealNode(obj, this.sensitiveProp);
        return obj;
    }
}

