/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.chemors.secure.ext.log.defender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import io.gitee.chemors.secure.ext.config.SensitiveProp;
import io.gitee.chemors.secure.ext.log.defender.LogBackDefender;
import io.gitee.chemors.secure.ext.util.LogInfoCategoryUtil;
import java.util.Map;
import java.util.StringTokenizer;

public class SensitiveObjMessageDefender
implements LogBackDefender {
    private SensitiveProp sensitiveProp;

    public SensitiveObjMessageDefender(SensitiveProp sensitiveProp) {
        this.sensitiveProp = sensitiveProp;
    }

    @Override
    public void desensitize(ILoggingEvent event, StringBuilder buffer) {
        String message = event.getMessage();
        Object[] objects = event.getArgumentArray();
        if (objects == null || !this.sensitiveProp.getLogInfo().getEnable().booleanValue()) {
            buffer.append(event.getFormattedMessage());
            return;
        }
        if (event.getFormattedMessage().contains("^")) {
            message = this.buildStrParams(event.getFormattedMessage());
        } else {
            for (Object o : objects) {
                message = message.replaceFirst("\\{\\}", this.dealNode(o, this.sensitiveProp));
            }
        }
        buffer.append(message);
    }

    private String buildStrParams(String str) {
        StringTokenizer stringTokenizer = new StringTokenizer(str, " ");
        while (stringTokenizer.hasMoreElements()) {
            String[] arr;
            String sensitiveStr;
            String token = stringTokenizer.nextToken();
            if (!token.contains("^") || StrUtil.isBlankIfStr((Object)(sensitiveStr = LogInfoCategoryUtil.format((arr = token.split("\\^"))[0], arr[1], this.sensitiveProp)))) continue;
            str = str.replaceFirst(arr[0] + "\\^" + arr[1], sensitiveStr);
        }
        return str;
    }

    private String dealNode(Object o, SensitiveProp sensitiveProp) {
        if (o == null) {
            return null;
        }
        Map map = (Map)JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)o), Map.class);
        map.replaceAll((k, v) -> LogInfoCategoryUtil.format(k, v, sensitiveProp));
        return JSONUtil.toJsonStr((Object)map);
    }
}

