/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.chemors.secure.ext.util;

import cn.hutool.core.util.StrUtil;
import io.gitee.chemors.secure.ext.annotations.DesensitizationProp;
import io.gitee.chemors.secure.ext.config.SensitiveProp;
import io.gitee.chemors.secure.ext.util.MosDesensitizedUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldSensitiveUtil {
    private static void dealList(Object o, SensitiveProp sensitiveProp) throws IllegalAccessException {
        List list = (List)o;
        for (Object obj : list) {
            FieldSensitiveUtil.dealNode(obj, sensitiveProp);
        }
    }

    private static void dealMap(Object o, SensitiveProp sensitiveProp) throws IllegalAccessException {
        Map map = (Map)o;
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() instanceof List) {
                FieldSensitiveUtil.dealList(entry.getValue(), sensitiveProp);
                continue;
            }
            FieldSensitiveUtil.dealNode(entry.getValue(), sensitiveProp);
        }
    }

    public static void dealNode(Object o, SensitiveProp sensitiveProp) throws IllegalAccessException {
        Field[] fields;
        if (o == null) {
            return;
        }
        if (o instanceof List) {
            FieldSensitiveUtil.dealList(o, sensitiveProp);
            return;
        }
        if (o instanceof Map) {
            FieldSensitiveUtil.dealMap(o, sensitiveProp);
            return;
        }
        boolean needDepthDeal = sensitiveProp.getDepth() != false && !StrUtil.isBlankIfStr((Object)sensitiveProp.getPackages());
        for (Field field : fields = o.getClass().getDeclaredFields()) {
            DesensitizationProp desensitizationProp;
            field.setAccessible(true);
            String type = field.getGenericType().toString();
            Object fieldValueObj = field.get(o);
            if (fieldValueObj instanceof List) {
                FieldSensitiveUtil.dealList(fieldValueObj, sensitiveProp);
            }
            if (needDepthDeal && FieldSensitiveUtil.containType(type, sensitiveProp).booleanValue()) {
                FieldSensitiveUtil.dealNode(fieldValueObj, sensitiveProp);
            }
            if ((desensitizationProp = field.getAnnotation(DesensitizationProp.class)) == null) continue;
            String v = MosDesensitizedUtil.desensitizeData(fieldValueObj, desensitizationProp);
            field.set(o, v);
        }
    }

    private static Boolean containType(String type, SensitiveProp sensitiveProp) {
        String[] scanPackages = sensitiveProp.getPackages().split(",");
        boolean isContainType = false;
        for (String scanPackage : scanPackages) {
            if (!type.contains(scanPackage)) continue;
            isContainType = true;
            break;
        }
        return isContainType;
    }
}

