/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionWriter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DynamicRouteListener
implements InitializingBean,
ApplicationEventPublisherAware {
    private static final Logger log = LoggerFactory.getLogger(DynamicRouteListener.class);
    private static final String GATEWAY_ROUTES = "gateway-routes.json";
    @Resource
    private NacosConfigManager nacosConfigManager;
    @Resource
    private NacosConfigProperties nacosConfigProperties;
    @Resource
    private RouteDefinitionWriter routeDefinitionWriter;
    private static final List<String> ROUTE_IDS = new ArrayList();
    private ApplicationEventPublisher applicationEventPublisher;

    public void afterPropertiesSet() throws Exception {
        ConfigService configService = this.nacosConfigManager.getConfigService();
        if (null == configService || null == this.nacosConfigProperties) {
            log.error("\u52a8\u6001\u8def\u7531\u4fa6\u542c\u5931\u8d25");
            return;
        }
        new Thread(() -> {
            String config = null;
            try {
                log.info("Loading Gateway Route File: {}", (Object)GATEWAY_ROUTES);
                config = this.nacosConfigManager.getConfigService().getConfig(GATEWAY_ROUTES, this.nacosConfigProperties.getGroup(), 3000L);
            }
            catch (NacosException e) {
                log.error("nacos exception", (Throwable)e);
            }
            this.refresh(config);
        }).start();
        configService.addListener(GATEWAY_ROUTES, this.nacosConfigProperties.getGroup(), (Listener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void refresh(String configInfo) {
        if (StrUtil.isBlank((CharSequence)configInfo)) {
            log.warn("Read File is null");
            return;
        }
        log.info("\u914d\u7f6e\u4fe1\u606f \n {}", (Object)configInfo);
        for (String routeId : ROUTE_IDS) {
            this.routeDefinitionWriter.delete(Mono.just((Object)routeId)).subscribe();
        }
        ROUTE_IDS.clear();
        JSONArray objects = JSONUtil.parseArray((String)configInfo);
        List routeDefinitions = objects.toList(RouteDefinition.class);
        if (CollUtil.isEmpty((Collection)routeDefinitions)) {
            return;
        }
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.routeDefinitionWriter.save(Mono.just((Object)routeDefinition)).subscribe();
            ROUTE_IDS.add(routeDefinition.getId());
        }
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent((Object)this.routeDefinitionWriter));
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    static /* synthetic */ void access$000(DynamicRouteListener x0, String x1) {
        x0.refresh(x1);
    }
}

