/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.config;

import io.gitee.dqcer.mcdull.gateway.handler.ExceptionHandler;
import io.gitee.dqcer.mcdull.gateway.properties.McdullGatewayProperties;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.filter.ratelimit.KeyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsWebFilter;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

@Configuration
@EnableConfigurationProperties(value={McdullGatewayProperties.class})
public class GatewayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GatewayConfiguration.class);

    @Bean
    public WebExceptionHandler webExceptionHandler() {
        return new ExceptionHandler();
    }

    @Bean
    @Profile(value={"dev"})
    public CorsWebFilter corsWebFilter() {
        log.info("CorsWebFilter ...");
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource(new PathPatternParser());
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowCredentials(Boolean.valueOf(true));
        ArrayList<String> allowedOriginPatterns = new ArrayList<String>();
        allowedOriginPatterns.add("*");
        configuration.setAllowedOriginPatterns(allowedOriginPatterns);
        configuration.addAllowedHeader("*");
        configuration.addAllowedMethod("*");
        configurationSource.registerCorsConfiguration("/**", configuration);
        return new CorsWebFilter((CorsConfigurationSource)configurationSource);
    }

    @Bean
    public KeyResolver tenantKeyResolver() {
        return exchange -> {
            ServerHttpRequest request = exchange.getRequest();
            String tenantId = request.getHeaders().getFirst("tenant_id");
            return Mono.just((Object)tenantId);
        };
    }

    @Primary
    @Bean
    public KeyResolver ipKeyResolver() {
        return exchange -> Mono.just((Object)exchange.getRequest().getRemoteAddress().getHostName());
    }

    @Bean
    public KeyResolver apiKeyResolver() {
        return exchange -> Mono.just((Object)exchange.getRequest().getPath().value());
    }
}

