/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.filter;

import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public abstract class AbstractFilter {
    protected void addHeader(ServerHttpRequest.Builder mutate, String name, Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        mutate.header(name, new String[]{valueStr});
    }

    protected Mono<Void> errorResponse(ServerHttpResponse response, int code, String msg) {
        response.getHeaders().add("Content-Type", "application/json");
        response.setStatusCode(HttpStatus.OK);
        String m = "{\"code\":" + code + ", \"data\":null, \"msg\":\"" + msg + "\"}";
        DataBuffer dataBuffer = response.bufferFactory().wrap(m.getBytes());
        return response.writeWith((Publisher)Mono.just((Object)dataBuffer));
    }

    protected boolean isNumber(String str) {
        return str.matches("^[0-9]*$");
    }
}

