/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.filter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.gitee.dqcer.mcdull.framework.base.wrapper.CodeEnum;
import io.gitee.dqcer.mcdull.framework.base.wrapper.Result;
import io.gitee.dqcer.mcdull.gateway.filter.AbstractFilter;
import io.gitee.dqcer.mcdull.gateway.properties.FilterProperties;
import io.gitee.dqcer.mcdull.gateway.properties.McdullGatewayProperties;
import io.gitee.dqcer.mcdull.gateway.utils.SpringUtils;
import io.gitee.dqcer.mcdull.uac.client.service.AuthClientService;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 3000L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("auth-pool-%d").build());
    @Resource
    private McdullGatewayProperties mcdullGatewayProperties;
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest.Builder mutate = request.mutate();
        HttpHeaders headers = request.getHeaders();
        String requestUrl = exchange.getRequest().getURI().getPath();
        FilterProperties filterProperties = this.mcdullGatewayProperties.getFilter();
        if (this.ignoreFilter(request.getPath().toString(), filterProperties.getNoAuth())) {
            if (log.isDebugEnabled()) {
                log.debug("Gateway Filer ignore url\uff1a{}", (Object)request.getPath());
            }
            return chain.filter(exchange);
        }
        if (requestUrl.toLowerCase().contains("/interior-def")) {
            log.warn("\u5185\u90e8feign\u63a5\u53e3\uff0c\u5916\u90e8\u975e\u6cd5\u8c03\u7528");
            return this.errorResponse(response, CodeEnum.NOT_FOUND.getCode().intValue(), CodeEnum.NOT_FOUND.getMessage());
        }
        Boolean enableMultiTenant = filterProperties.getEnableMultiTenant();
        if (enableMultiTenant.booleanValue()) {
            String tenantIdStr = headers.getFirst("tid");
            if (log.isDebugEnabled()) {
                log.debug("Gateway Filer TenantId: {}", (Object)tenantIdStr);
            }
            if (null == tenantIdStr || tenantIdStr.trim().length() == 0) {
                log.error("\u5934\u90e8tid\u53c2\u6570\u7f3a\u5931");
                return this.errorResponse(response, CodeEnum.ERROR_PARAMETERS.getCode().intValue(), CodeEnum.ERROR_PARAMETERS.getMessage());
            }
            if (!this.isNumber(tenantIdStr)) {
                log.error("\u5934\u90e8tid\u53c2\u6570\u5f02\u5e38");
                return this.errorResponse(response, CodeEnum.ERROR_PARAMETERS.getCode().intValue(), CodeEnum.ERROR_PARAMETERS.getMessage());
            }
            this.addHeader(mutate, "tid", (Object)tenantIdStr);
        }
        String authorization = headers.getFirst("Authorization");
        if (log.isDebugEnabled()) {
            log.debug("Gateway Filer Authorization: {}", (Object)authorization);
        }
        if (null == authorization || authorization.trim().length() == 0) {
            log.error("\u5934\u90e8Authorization\u53c2\u6570\u7f3a\u5931");
            return this.errorResponse(response, CodeEnum.UN_AUTHORIZATION.getCode().intValue(), CodeEnum.UN_AUTHORIZATION.getMessage());
        }
        String token = authorization.substring("Bearer ".length());
        if (token.trim().length() == 0) {
            log.error("\u5934\u90e8Authorization\u53c2\u6570\u7f3a\u5931Bearer ");
            return this.errorResponse(response, CodeEnum.UN_AUTHORIZATION.getCode().intValue(), CodeEnum.UN_AUTHORIZATION.getMessage());
        }
        String traceId = headers.getFirst("x-trace-header");
        Result result = AuthFilter.remoteValid((String)token, (String)traceId);
        log.info("token valid result: {}", (Object)result);
        if (!result.isOk()) {
            return this.errorResponse(response, result.getCode(), result.getMessage());
        }
        this.addHeader(mutate, "uid", result.getData());
        this.addHeader(mutate, "token", (Object)token);
        return chain.filter(exchange.mutate().request(mutate.build()).build());
    }

    private static Result<Integer> remoteValid(String token, String traceId) {
        Result result;
        AuthClientService authClientService = (AuthClientService)SpringUtils.getBean(AuthClientService.class);
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        Future<Result> future = executorService.submit(() -> authClientService.tokenValid(token, traceId));
        try {
            result = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return result;
    }

    public boolean ignoreFilter(String path, List<String> list) {
        return list.stream().anyMatch(url -> path.startsWith((String)url) || PATH_MATCHER.match(url, path));
    }

    public int getOrder() {
        return 0;
    }
}

