/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.filter;

import io.gitee.dqcer.mcdull.framework.base.util.RandomUtil;
import io.gitee.dqcer.mcdull.gateway.filter.AbstractFilter;
import io.gitee.dqcer.mcdull.gateway.utils.IpUtils;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class LogFilter
extends AbstractFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(LogFilter.class);
    private static final String START_TIME = "startTime";

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder mutate = request.mutate();
        String traceId = RandomUtil.uuid();
        this.addHeader(mutate, "x-trace-header", (Object)traceId);
        MDC.put((String)"traceId", (String)traceId);
        if (log.isInfoEnabled()) {
            log.info("\u8bf7\u6c42\u5730\u5740:{} {} \u6765\u6e90Ip: {}", new Object[]{request.getMethodValue(), request.getURI(), IpUtils.getRealIp((ServerHttpRequest)request)});
        }
        HttpHeaders headers = exchange.getRequest().getHeaders();
        StringJoiner keyValue = new StringJoiner(", ");
        headers.forEach((headerName, headerValue) -> keyValue.add(headerName + ":" + String.join((CharSequence)",", headerValue)));
        if (log.isInfoEnabled()) {
            log.info("===Headers===  {}", (Object)keyValue);
        }
        exchange.getAttributes().put(START_TIME, System.currentTimeMillis());
        return chain.filter(exchange).then(Mono.fromRunnable(() -> {
            Long startTime = (Long)exchange.getAttribute(START_TIME);
            long executeTime = 0L;
            if (startTime != null) {
                executeTime = System.currentTimeMillis() - startTime;
            }
            log.info("\u8017\u65f6: {} ms", (Object)executeTime);
            MDC.remove((String)"traceId");
        }));
    }

    private String resolveBodyFromRequest(ServerHttpRequest serverHttpRequest) {
        Flux body = serverHttpRequest.getBody();
        AtomicReference bodyRef = new AtomicReference();
        body.subscribe(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            bodyRef.set(charBuffer.toString());
        });
        return (String)bodyRef.get();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

