/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gitee.dqcer.mcdull.framework.base.wrapper.CodeEnum;
import io.gitee.dqcer.mcdull.framework.base.wrapper.ICode;
import io.gitee.dqcer.mcdull.framework.base.wrapper.Result;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.annotation.Resource;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebExceptionHandler;
import reactor.core.publisher.Mono;

public class ExceptionHandler
implements WebExceptionHandler,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    @Resource
    private ObjectMapper objectMapper;

    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        ServerHttpResponse response = exchange.getResponse();
        ServerHttpRequest request = exchange.getRequest();
        URI uri = request.getURI();
        log.error("gateway exception uri: {} message: {} ", (Object)uri, (Object)ex.getMessage());
        if (response.isCommitted()) {
            return Mono.error((Throwable)ex);
        }
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        response.setStatusCode(HttpStatus.OK);
        return response.writeWith((Publisher)Mono.fromSupplier(() -> {
            DataBufferFactory bufferFactory = response.bufferFactory();
            try {
                Result error;
                if (ex instanceof ResponseStatusException) {
                    HttpStatus status = ((ResponseStatusException)ex).getStatus();
                    error = Result.error((int)status.value(), (String)status.getReasonPhrase());
                } else {
                    log.warn("\u7f51\u5173\u5f02\u5e38\u5904\u7406: {}", (Object)ex.getMessage());
                    error = Result.error((ICode)CodeEnum.INTERNAL_SERVER_ERROR, Collections.singletonList(ex.getMessage()));
                }
                return bufferFactory.wrap(this.objectMapper.writeValueAsBytes((Object)error));
            }
            catch (JsonProcessingException e) {
                log.error("json \u5904\u7406\u5f02\u5e38", (Throwable)e);
                String m = "{\"code\":" + CodeEnum.INTERNAL_SERVER_ERROR + ", \"data\":null, \"message\":\"" + CodeEnum.INTERNAL_SERVER_ERROR.getMessage() + "\"}";
                return bufferFactory.wrap(m.getBytes(StandardCharsets.UTF_8));
            }
        }));
    }

    public int getOrder() {
        return -1;
    }
}

