/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.satoken;

import cn.dev33.satoken.stp.StpInterface;
import cn.hutool.core.convert.Convert;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.gitee.dqcer.mcdull.framework.base.wrapper.Result;
import io.gitee.dqcer.mcdull.gateway.utils.SpringUtils;
import io.gitee.dqcer.mcdull.uac.client.service.AuthClientService;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class StpInterfaceImpl
implements StpInterface {
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 3000L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("auth-pool-%d").build());

    public List<String> getPermissionList(Object loginId, String loginType) {
        return this.permissionList(loginId);
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        return this.roleList(loginId);
    }

    private List<String> permissionList(Object userId) {
        Result result;
        AuthClientService authClientService = (AuthClientService)SpringUtils.getBean(AuthClientService.class);
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        Future<Result> future = executorService.submit(() -> authClientService.getPermissionList(Convert.toLong((Object)userId)));
        try {
            result = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return (List)result.getData();
    }

    private List<String> roleList(Object userId) {
        Result result;
        AuthClientService authClientService = (AuthClientService)SpringUtils.getBean(AuthClientService.class);
        RequestContextHolder.setRequestAttributes((RequestAttributes)RequestContextHolder.getRequestAttributes(), (boolean)true);
        Future<Result> future = executorService.submit(() -> authClientService.getRoleList(Convert.toLong((Object)userId)));
        try {
            result = future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return (List)result.getData();
    }
}

