/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.dqcer.mcdull.gateway.utils;

import java.util.Objects;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class IpUtils {
    private static final String X_FORWARDED_FOR = "x-forwarded-for";
    private static final String PROXY_CLIENT_IP = "Proxy-Client-IP";
    private static final String WL_PROXY_CLIENT_IP = "WL-Proxy-Client-IP";
    private static final String HTTP_CLIENT_IP = "HTTP_CLIENT_IP";
    private static final String HTTP_X_FORWARDED_FOR = "HTTP_X_FORWARDED_FOR";
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String UNKNOWN = "unknown";
    private static final String SPLIT = ",";

    private IpUtils() {
    }

    public static String getRealIp(ServerHttpRequest request) {
        boolean contains;
        HttpHeaders headers = request.getHeaders();
        String ip = headers.getFirst("x-forwarded-for");
        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip) && (contains = ip.contains(","))) {
            ip = ip.split(",")[0];
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = headers.getFirst("Proxy-Client-IP");
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = headers.getFirst("WL-Proxy-Client-IP");
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = headers.getFirst("HTTP_CLIENT_IP");
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = headers.getFirst("HTTP_X_FORWARDED_FOR");
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = headers.getFirst("X-Real-IP");
        }
        if (IpUtils.checkIp((String)ip)) {
            ip = Objects.requireNonNull(request.getRemoteAddress()).getAddress().getHostAddress();
        }
        return ip;
    }

    private static boolean checkIp(String ip) {
        return ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip);
    }
}

