/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperConfiguration;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.DefaultArrayAdapter;
import freemarker.template.DefaultEnumerationAdapter;
import freemarker.template.DefaultIterableAdapter;
import freemarker.template.DefaultIteratorAdapter;
import freemarker.template.DefaultListAdapter;
import freemarker.template.DefaultMapAdapter;
import freemarker.template.DefaultNonListCollectionAdapter;
import freemarker.template.DefaultObjectWrapperConfiguration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.Version;
import freemarker.template._TemplateAPI;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class DefaultObjectWrapper
extends BeansWrapper {
    @Deprecated
    static final DefaultObjectWrapper instance = new DefaultObjectWrapper();
    private boolean useAdaptersForContainers;
    private boolean forceLegacyNonListCollections;
    private boolean iterableSupport;
    private boolean domNodeSupport;
    private final boolean useAdapterForEnumerations;

    @Deprecated
    public DefaultObjectWrapper() {
        this(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    public DefaultObjectWrapper(Version incompatibleImprovements) {
        this(new DefaultObjectWrapperConfiguration(incompatibleImprovements){}, false);
    }

    protected DefaultObjectWrapper(BeansWrapperConfiguration bwCfg, boolean writeProtected) {
        super(bwCfg, writeProtected, false);
        DefaultObjectWrapperConfiguration dowDowCfg = bwCfg instanceof DefaultObjectWrapperConfiguration ? (DefaultObjectWrapperConfiguration)bwCfg : new DefaultObjectWrapperConfiguration(bwCfg.getIncompatibleImprovements()){};
        this.useAdaptersForContainers = dowDowCfg.getUseAdaptersForContainers();
        this.useAdapterForEnumerations = this.useAdaptersForContainers && this.getIncompatibleImprovements().intValue() >= _TemplateAPI.VERSION_INT_2_3_26;
        this.forceLegacyNonListCollections = dowDowCfg.getForceLegacyNonListCollections();
        this.iterableSupport = dowDowCfg.getIterableSupport();
        this.domNodeSupport = dowDowCfg.getDOMNodeSupport();
        this.finalizeConstruction(writeProtected);
    }

    protected DefaultObjectWrapper(DefaultObjectWrapperConfiguration dowCfg, boolean writeProtected) {
        this((BeansWrapperConfiguration)dowCfg, writeProtected);
    }

    @Override
    public TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return super.wrap(null);
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)obj;
        }
        if (obj instanceof String) {
            return new SimpleScalar((String)obj);
        }
        if (obj instanceof Number) {
            return new SimpleNumber((Number)obj);
        }
        if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                return new SimpleDate((Date)obj);
            }
            if (obj instanceof Time) {
                return new SimpleDate((Time)obj);
            }
            if (obj instanceof Timestamp) {
                return new SimpleDate((Timestamp)obj);
            }
            return new SimpleDate((java.util.Date)obj, this.getDefaultDateType());
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            if (this.useAdaptersForContainers) {
                return DefaultArrayAdapter.adapt(obj, this);
            }
            obj = this.convertArray(obj);
        }
        if (obj instanceof Collection) {
            if (this.useAdaptersForContainers) {
                if (obj instanceof List) {
                    return DefaultListAdapter.adapt((List)obj, this);
                }
                return this.forceLegacyNonListCollections ? new SimpleSequence((Collection)obj, (ObjectWrapper)this) : DefaultNonListCollectionAdapter.adapt((Collection)obj, this);
            }
            return new SimpleSequence((Collection)obj, (ObjectWrapper)this);
        }
        if (obj instanceof Map) {
            return this.useAdaptersForContainers ? DefaultMapAdapter.adapt((Map)obj, this) : new SimpleHash((Map)obj, this);
        }
        if (obj instanceof Boolean) {
            return obj.equals(Boolean.TRUE) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
        if (obj instanceof Iterator) {
            return this.useAdaptersForContainers ? DefaultIteratorAdapter.adapt((Iterator)obj, this) : new SimpleCollection((Iterator)obj, (ObjectWrapper)this);
        }
        if (this.useAdapterForEnumerations && obj instanceof Enumeration) {
            return DefaultEnumerationAdapter.adapt((Enumeration)obj, this);
        }
        if (this.iterableSupport && obj instanceof Iterable) {
            return DefaultIterableAdapter.adapt((Iterable)obj, this);
        }
        return this.handleUnknownType(obj);
    }

    protected TemplateModel handleUnknownType(Object obj) throws TemplateModelException {
        if (this.domNodeSupport && obj instanceof Node) {
            return this.wrapDomNode(obj);
        }
        return super.wrap(obj);
    }

    public TemplateModel wrapDomNode(Object obj) {
        return NodeModel.wrap((Node)obj);
    }

    protected Object convertArray(Object arr) {
        int size = Array.getLength(arr);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(Array.get(arr, i));
        }
        return list;
    }

    public boolean getUseAdaptersForContainers() {
        return this.useAdaptersForContainers;
    }

    public void setUseAdaptersForContainers(boolean useAdaptersForContainers) {
        this.checkModifiable();
        this.useAdaptersForContainers = useAdaptersForContainers;
    }

    public boolean getForceLegacyNonListCollections() {
        return this.forceLegacyNonListCollections;
    }

    public void setForceLegacyNonListCollections(boolean forceLegacyNonListCollections) {
        this.checkModifiable();
        this.forceLegacyNonListCollections = forceLegacyNonListCollections;
    }

    public boolean getIterableSupport() {
        return this.iterableSupport;
    }

    public void setIterableSupport(boolean iterableSupport) {
        this.checkModifiable();
        this.iterableSupport = iterableSupport;
    }

    public final boolean getDOMNodeSupport() {
        return this.domNodeSupport;
    }

    public void setDOMNodeSupport(boolean domNodeSupport) {
        this.checkModifiable();
        this.domNodeSupport = domNodeSupport;
    }

    protected static Version normalizeIncompatibleImprovementsVersion(Version incompatibleImprovements) {
        _TemplateAPI.checkVersionNotNullAndSupported(incompatibleImprovements);
        Version bwIcI = BeansWrapper.normalizeIncompatibleImprovementsVersion(incompatibleImprovements);
        return incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_22 || bwIcI.intValue() >= _TemplateAPI.VERSION_INT_2_3_22 ? bwIcI : Configuration.VERSION_2_3_22;
    }

    @Override
    protected String toPropertiesString() {
        int smwEnd;
        String bwProps = super.toPropertiesString();
        if (bwProps.startsWith("simpleMapWrapper") && (smwEnd = bwProps.indexOf(44)) != -1) {
            bwProps = bwProps.substring(smwEnd + 1).trim();
        }
        return "useAdaptersForContainers=" + this.useAdaptersForContainers + ", forceLegacyNonListCollections=" + this.forceLegacyNonListCollections + ", iterableSupport=" + this.iterableSupport + ", domNodeSupport=" + this.domNodeSupport + bwProps;
    }
}

