/*
 * Decompiled with CFR 0.152.
 */
package com.bh;

import com.bh.ResourceHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class ChineseToBihuaResource {
    private Properties unicodeToHanyuBihuaTable = null;

    private void setUnicodeToHanyuBihuaTable(Properties paramProperties) {
        this.unicodeToHanyuBihuaTable = paramProperties;
    }

    private Properties getUnicodeToHanyuBihuaTable() {
        return this.unicodeToHanyuBihuaTable;
    }

    private ChineseToBihuaResource() {
        this.initializeResource();
    }

    private void initializeResource() {
        try {
            this.setUnicodeToHanyuBihuaTable(new Properties());
            this.getUnicodeToHanyuBihuaTable().load(ResourceHelper.getResourceInputStream("/bihuadb/unicode_to_hanyu_bihua.txt"));
        }
        catch (FileNotFoundException localFileNotFoundException) {
            localFileNotFoundException.printStackTrace();
        }
        catch (IOException localIOException) {
            localIOException.printStackTrace();
        }
    }

    public int getHanyuBihuaString(char paramChar) {
        String str1 = this.getHanyuBihuaRecordFromChar(paramChar);
        if (null != str1) {
            int i = str1.indexOf("(");
            int j = str1.lastIndexOf(")");
            String str2 = str1.substring(i + 1, j);
            return Integer.valueOf(str2);
        }
        return 0;
    }

    private String getHanyuBihuaRecordFromChar(char paramChar) {
        char i = paramChar;
        String str1 = Integer.toHexString(i).toUpperCase();
        String str2 = this.getUnicodeToHanyuBihuaTable().getProperty(str1);
        return str2;
    }

    static ChineseToBihuaResource getInstance() {
        return ChineseToBihuaResourceHolder.theInstance;
    }

    private static class ChineseToBihuaResourceHolder {
        static final ChineseToBihuaResource theInstance = new ChineseToBihuaResource();

        private ChineseToBihuaResourceHolder() {
        }
    }
}

