/*
 * Decompiled with CFR 0.152.
 */
package tx.plus;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tx.plus.Connection");
    private final DataSource dataSource;
    private String username;
    private String password;
    private Connection target;
    private Boolean autoCommit;
    private Boolean autoCommitInit;
    private boolean autoCommitPromise;
    private boolean autoCommitPromiseSuc;
    private static final boolean DEFAULT_AUTO_COMMIT = true;

    ConnectionHandler(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    ConnectionHandler(DataSource dataSource, String username, String password) {
        this.dataSource = dataSource;
        this.username = username;
        this.password = password;
    }

    private void connect() throws SQLException {
        this.target = this.username == null ? this.dataSource.getConnection() : this.dataSource.getConnection(this.username, this.password);
        LOGGER.info("getConnection");
        if (this.autoCommitPromise) {
            Boolean _autoCommit = this.autoCommit;
            boolean _autoCommitInit = this.target.getAutoCommit();
            LOGGER.debug("getAutoCommit - {}", (Object)_autoCommitInit);
            if (_autoCommitInit) {
                this.autoCommitPromiseSuc = true;
            } else {
                this.autoCommitInit = _autoCommitInit;
            }
            if (_autoCommit != null && _autoCommit != _autoCommitInit) {
                LOGGER.info("setAutoCommit - {}", (Object)_autoCommit);
                this.target.setAutoCommit(_autoCommit);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if (this.target == null) {
            if ("setAutoCommit".equals(method.getName())) {
                this.autoCommit = (Boolean)args[0];
                LOGGER.debug("lazy - {} - {}", (Object)method.getName(), (Object)this.autoCommit);
                return null;
            }
            if ("getAutoCommit".equals(method.getName())) {
                Boolean _autoCommit = this.autoCommit;
                if (_autoCommit == null) {
                    this.autoCommit = _autoCommit = Boolean.valueOf(true);
                    this.autoCommitPromise = true;
                }
                LOGGER.debug("lazy - {} -> {}", (Object)method.getName(), (Object)_autoCommit);
                return _autoCommit;
            }
            if ("commit".equals(method.getName()) || "rollback".equals(method.getName()) || "close".equals(method.getName())) {
                LOGGER.info("ignore - {}", (Object)method.getName());
                return null;
            }
            this.connect();
            LOGGER.debug("{} - {}", (Object)method.getName(), args == null ? null : Arrays.asList(args));
            return method.invoke((Object)this.target, args);
        }
        if ("setAutoCommit".equals(method.getName())) {
            this.autoCommit = (Boolean)args[0];
        } else if ("close".equals(method.getName()) && this.autoCommitPromise && !this.autoCommitPromiseSuc) {
            LOGGER.info("setAutoCommit - {}", (Object)this.autoCommitInit);
            this.target.setAutoCommit(this.autoCommitInit);
        }
        LOGGER.debug("{} - {}", (Object)method.getName(), args == null ? null : Arrays.asList(args));
        return method.invoke((Object)this.target, args);
    }
}

