/*
 * Decompiled with CFR 0.152.
 */
package tx.plus;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import lombok.Generated;
import tx.plus.ConnectionHandler;

public class PlusDataSource
implements DataSource {
    private final Constructor<? extends Connection> lazyConnectionConstructor;
    private final DataSource dataSource;

    public PlusDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        Connection connection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler(null));
        this.lazyConnectionConstructor = connection.getClass().getConstructor(InvocationHandler.class);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.lazyConnectionConstructor.newInstance(new ConnectionHandler(this.dataSource, username, password));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.lazyConnectionConstructor.newInstance(new ConnectionHandler(this.dataSource));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Generated
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

