/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhousiwei;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import io.gitee.zhousiwei.FastJsonProperties;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
@ConditionalOnProperty(name={"fastjson.enabled"}, matchIfMissing=true)
public class FastJsonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public FastJsonProperties fastJsonProperties() {
        return new FastJsonProperties();
    }

    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters(FastJsonProperties fastJsonProperties) {
        System.err.println("starter for fastJson-----fastJson init success.");
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        for (String mediaType : fastJsonProperties.getMediaType()) {
            supportedMediaTypes.add(MediaType.parseMediaType((String)mediaType));
        }
        fastConverter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setDateFormat(fastJsonProperties.getDateFormat());
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat});
        fastConverter.setFastJsonConfig(fastJsonConfig);
        return new HttpMessageConverters(new HttpMessageConverter[]{fastConverter});
    }
}

