/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.net.http.HttpClient;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateJdkHttpClientProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.JdkHttpClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.logger.RestTemplateLoggingInterceptor;

@Configuration
@ConditionalOnClass(value={HttpClient.class})
@ConditionalOnMissingClass(value={"org.springframework.cloud.context.config.annotation.RefreshScope"})
@ConditionalOnProperty(name={"spring.rest.jdkhttp.enabled"}, havingValue="true")
public class RestTemplateJdkHttpClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConfigurationProperties(prefix="spring.rest.jdkhttp")
    protected RestTemplateJdkHttpClientProperties restTemplateJdkHttpClientProperties() {
        return new RestTemplateJdkHttpClientProperties();
    }

    @Bean
    protected RestTemplate restTemplate(RestTemplateJdkHttpClientProperties properties, ObjectProvider<RestTemplateBuilder> builderProvider) {
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(properties.getConnectionTimeout()).followRedirects(properties.getRedirect()).version(properties.getHttpVersion());
        Optional.ofNullable(properties.getHttp2Priority()).ifPresent(p -> builder.priority((int)p));
        HttpClient httpClient = builder.build();
        return ((RestTemplateBuilder)builderProvider.getIfAvailable(() -> new RestTemplateBuilder(new RestTemplateCustomizer[0]))).requestFactory(() -> new JdkHttpClientHttpRequestFactory(httpClient, properties.getReadTimeout())).interceptors(new ClientHttpRequestInterceptor[]{new RestTemplateLoggingInterceptor(properties.getLevel())}).build();
    }
}

