/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpClientHttpResponse;
import org.springframework.http.client.JdkHttpClientHttpRequestFactory;

public class HttpClientClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpClient client;
    private final URI uri;
    private final HttpMethod method;
    private final Duration readTimeout;
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

    public HttpClientClientHttpRequest(HttpClient client, URI uri, HttpMethod method, Duration readTimeout) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.readTimeout = readTimeout;
    }

    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.bufferedOutput;
    }

    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        byte[] content = this.bufferedOutput.toByteArray();
        HttpRequest request = JdkHttpClientHttpRequestFactory.buildRequest(headers, content, this.getURI(), this.getMethodValue(), this.readTimeout);
        try {
            HttpResponse<InputStream> response = this.client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            HttpClientHttpResponse httpClientHttpResponse = new HttpClientHttpResponse(response);
            return httpClientHttpResponse;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        finally {
            this.bufferedOutput = new ByteArrayOutputStream(0);
        }
    }

    public String getMethodValue() {
        return this.method.name();
    }

    public URI getURI() {
        return this.uri;
    }
}

