/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpClientClientHttpRequest;
import org.springframework.web.util.HttpClientUtil;

public class JdkHttpClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient client;
    private final Duration readTimeout;

    public JdkHttpClientHttpRequestFactory(HttpClient client, Duration readTimeout) {
        this.client = client;
        this.readTimeout = readTimeout;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new HttpClientClientHttpRequest(this.client, uri, httpMethod, this.readTimeout);
    }

    public static HttpRequest buildRequest(HttpHeaders headers, byte[] content, URI uri, String method, Duration readTimeout) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri);
        headers.forEach((name, list) -> {
            if (HttpClientUtil.allowed(name)) {
                list.forEach(value -> builder.header((String)name, (String)value));
            }
        });
        headers.computeIfAbsent((Object)"Accept", key -> List.of("*/*"));
        if (content.length > 0) {
            builder.method(method, HttpRequest.BodyPublishers.ofByteArray(content));
        } else {
            builder.method(method, HttpRequest.BodyPublishers.noBody());
        }
        return builder.timeout(readTimeout).build();
    }
}

