/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.config;

import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Objects;
import org.springframework.web.client.logger.HttpLogLevel;

public class RestTemplateJdkHttpClientConfig {
    public static final int MIN_PRIORITY = 1;
    public static final int MAX_PRIORITY = 256;
    private boolean enabled = false;
    private HttpLogLevel level = HttpLogLevel.BASIC;
    private Duration connectionTimeout = Duration.ofMillis(2000L);
    private Duration readTimeout = Duration.ofMillis(2000L);
    private Integer http2Priority;
    private HttpClient.Redirect redirect = HttpClient.Redirect.ALWAYS;
    private HttpClient.Version httpVersion = HttpClient.Version.HTTP_1_1;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HttpLogLevel getLevel() {
        return this.level;
    }

    public RestTemplateJdkHttpClientConfig setLevel(HttpLogLevel level) {
        this.level = level;
        return this;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public RestTemplateJdkHttpClientConfig setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public RestTemplateJdkHttpClientConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Integer getHttp2Priority() {
        return this.http2Priority;
    }

    public RestTemplateJdkHttpClientConfig setHttp2Priority(Integer http2Priority) {
        if (RestTemplateJdkHttpClientConfig.isValidHttp2Priority(http2Priority)) {
            this.http2Priority = http2Priority;
        }
        return this;
    }

    public HttpClient.Redirect getRedirect() {
        return this.redirect;
    }

    public RestTemplateJdkHttpClientConfig setRedirect(HttpClient.Redirect redirect) {
        this.redirect = redirect;
        return this;
    }

    public HttpClient.Version getHttpVersion() {
        return this.httpVersion;
    }

    public RestTemplateJdkHttpClientConfig setHttpVersion(HttpClient.Version httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectionTimeout, this.enabled, this.http2Priority, this.httpVersion, this.level, this.readTimeout, this.redirect});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestTemplateJdkHttpClientConfig other = (RestTemplateJdkHttpClientConfig)obj;
        return Objects.equals(this.connectionTimeout, other.connectionTimeout) && this.enabled == other.enabled && this.http2Priority == other.http2Priority && this.httpVersion == other.httpVersion && this.level == other.level && Objects.equals(this.readTimeout, other.readTimeout) && this.redirect == other.redirect;
    }

    public String toString() {
        return "RestTemplateJdkHttpClientConfig [enabled=" + this.enabled + ", level=" + this.level + ", connectionTimeout=" + this.connectionTimeout + ", readTimeout=" + this.readTimeout + ", http2Priority=" + this.http2Priority + ", redirect=" + this.redirect + ", httpVersion=" + this.httpVersion + "]";
    }

    public static boolean isValidHttp2Priority(Integer http2Priority) {
        if (null == http2Priority) {
            return false;
        }
        int priority = http2Priority;
        return priority >= 1 && priority <= 256;
    }
}

