/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.logger;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.logger.ClientHttpResponseLogWrapper;
import org.springframework.web.client.logger.HttpLogLevel;

public class RestTemplateLoggingInterceptor
implements ClientHttpRequestInterceptor {
    private static Logger log = LoggerFactory.getLogger(RestTemplateLoggingInterceptor.class);
    private final HttpLogLevel logLevel;

    public RestTemplateLoggingInterceptor(HttpLogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (HttpLogLevel.NONE == this.logLevel) {
            return execution.execute(request, body);
        }
        RestTemplateLoggingInterceptor.traceRequest(request, body, this.logLevel);
        long startNs = System.nanoTime();
        ClientHttpResponse response = HttpLogLevel.BODY.lte(this.logLevel) ? new ClientHttpResponseLogWrapper(execution.execute(request, body)) : execution.execute(request, body);
        RestTemplateLoggingInterceptor.traceResponse(response, this.logLevel, startNs);
        return response;
    }

    private static void traceRequest(HttpRequest request, byte[] body, HttpLogLevel logLevel) {
        boolean hasBody;
        boolean bl = hasBody = body != null && body.length > 0;
        if (hasBody) {
            log.info("--> {} {} ({}-byte body)", new Object[]{request.getMethod(), request.getURI(), body.length});
        } else {
            log.info("--> {} {}", (Object)request.getMethod(), (Object)request.getURI());
        }
        if (HttpLogLevel.HEADERS.lte(logLevel)) {
            HttpHeaders headers = request.getHeaders();
            headers.forEach((name, values) -> log.info("{}: {}", name, (Object)StringUtils.collectionToCommaDelimitedString((Collection)values)));
        }
        if (hasBody && HttpLogLevel.BODY.lte(logLevel)) {
            log.info("Request body: {}", (Object)new String(body, StandardCharsets.UTF_8));
        }
        log.info("--> END {}", (Object)request.getMethod());
    }

    private static void traceResponse(ClientHttpResponse response, HttpLogLevel logLevel, long startNs) throws IOException {
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        log.info("<--{} {}({}ms)", new Object[]{response.getRawStatusCode(), response.getStatusText(), tookMs});
        if (HttpLogLevel.HEADERS.lte(logLevel)) {
            HttpHeaders headers = response.getHeaders();
            headers.forEach((name, values) -> log.info("{}: {}", name, (Object)StringUtils.collectionToCommaDelimitedString((Collection)values)));
        }
        if (HttpLogLevel.BODY.lte(logLevel)) {
            log.info("Response body: {}", (Object)StreamUtils.copyToString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8));
        }
        log.info("<-- END HTTP");
    }
}

