/*
 * Decompiled with CFR 0.152.
 */
package com.example.opennodeapi;

import com.example.opennodeapi.models.OpenNodeChangeInfoList;
import com.example.opennodeapi.models.OpenNodeChargeInfo;
import com.example.opennodeapi.models.OpenNodeChargeResponse;
import com.example.opennodeapi.models.OpenNodeCreateCharge;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

@Service
public class OpenNodeService {
    private final String apiKey;
    private final String readKey;
    private final WebClient webClient;

    public OpenNodeService(@Value(value="${open.node.key}") String apiKey, @Value(value="${open.node.read_key}") String readKey) {
        this.apiKey = apiKey;
        this.readKey = readKey;
        this.webClient = WebClient.builder().baseUrl("https://api.opennode.com").defaultHeader("Content-Type", new String[]{"application/json"}).defaultHeader("accept", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{apiKey}).build();
    }

    public OpenNodeChargeResponse createCharge(OpenNodeCreateCharge charge) {
        return (OpenNodeChargeResponse)((WebClient.RequestBodySpec)this.webClient.post().uri("/v1/charges/", new Object[0])).body(BodyInserters.fromValue((Object)charge)).retrieve().bodyToMono(OpenNodeChargeResponse.class).block();
    }

    public OpenNodeChargeInfo getCharge(String id) {
        return (OpenNodeChargeInfo)this.webClient.get().uri("/v2/charge/{id}", new Object[]{id}).retrieve().bodyToMono(OpenNodeChargeInfo.class).block();
    }

    public List<OpenNodeChangeInfoList.OpenNodeChargeData> listPaidCharges() {
        OpenNodeChangeInfoList data = (OpenNodeChangeInfoList)this.webClient.get().uri("/v2/charges/", new Object[0]).header("Authorization", new String[]{this.readKey}).retrieve().bodyToMono(OpenNodeChangeInfoList.class).block();
        return data != null ? data.getData().getItems() : List.of();
    }
}

