/*
 * Decompiled with CFR 0.152.
 */
package com.example.opennodeapi;

import com.example.opennodeapi.OpenNodeService;
import com.example.opennodeapi.models.OpenNodeChangeInfoList;
import com.example.opennodeapi.models.OpenNodeChargeInfo;
import com.example.opennodeapi.models.OpenNodeChargeResponse;
import com.example.opennodeapi.models.OpenNodeCreateCharge;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class OpennodeApiApplication {
    public static void main(String[] args) {
        ConfigurableApplicationContext context = SpringApplication.run(OpennodeApiApplication.class, (String[])args);
        OpenNodeService openNodeService = (OpenNodeService)context.getBean(OpenNodeService.class);
        OpennodeApiApplication.createCharge(openNodeService);
    }

    private static void createCharge(OpenNodeService openNodeService) {
        OpenNodeCreateCharge charge = OpenNodeCreateCharge.builder().amount(1.0).build();
        OpenNodeChargeResponse createdCharge = openNodeService.createCharge(charge);
        System.out.println("Created Charge: " + String.valueOf(createdCharge));
    }

    private static void getCharge(OpenNodeService openNodeService, String chargeId) {
        OpenNodeChargeInfo chargeInfo = openNodeService.getCharge(chargeId);
        System.out.println("Charge Info: " + String.valueOf(chargeInfo));
    }

    private static void listCharges(OpenNodeService openNodeService) {
        List<OpenNodeChangeInfoList.OpenNodeChargeData> chargeList = openNodeService.listPaidCharges();
        System.out.println("Charge List: " + String.valueOf(chargeList));
    }
}

