/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.testgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.antlr.v4.testgen.JavaEscapeStringMap;
import org.antlr.v4.testgen.LinesStringMap;
import org.antlr.v4.testgen.STGroupModelAdaptor;
import org.antlr.v4.testgen.StrlenStringMap;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ModelAdaptor;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STErrorListener;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;
import org.stringtemplate.v4.gui.STViz;
import org.stringtemplate.v4.misc.ErrorBuffer;

public class TestGenerator {
    private final String encoding;
    private final File runtimeTemplates;
    private final File outputDirectory;
    private final boolean visualize;

    public TestGenerator(String encoding, File runtimeTemplates, File outputDirectory, boolean visualize) {
        this.encoding = encoding;
        this.runtimeTemplates = runtimeTemplates;
        this.outputDirectory = outputDirectory;
        this.visualize = visualize;
    }

    public void execute() {
        STGroupFile targetGroup = new STGroupFile(this.runtimeTemplates.getPath());
        targetGroup.registerModelAdaptor(STGroup.class, (ModelAdaptor)new STGroupModelAdaptor());
        targetGroup.registerRenderer(String.class, (AttributeRenderer)new StringRenderer(), true);
        targetGroup.defineDictionary("escape", (Map)new JavaEscapeStringMap());
        targetGroup.defineDictionary("lines", (Map)new LinesStringMap());
        targetGroup.defineDictionary("strlen", (Map)new StrlenStringMap());
        String rootFolder = "org/antlr/v4/test/runtime/templates";
        this.generateCodeForFoldersInIndex((STGroup)targetGroup, rootFolder);
    }

    protected void generateCodeForFoldersInIndex(STGroup targetGroup, String rootFolder) {
        STGroupFile index = new STGroupFile(rootFolder + "/Index.stg");
        index.load();
        Map folders = index.rawGetDictionary("TestFolders");
        if (folders != null) {
            for (String key : folders.keySet()) {
                String testdir = rootFolder + "/" + key;
                STGroupFile testIndex = new STGroupFile(testdir + "/Index.stg");
                testIndex.load();
                Map templateNames = testIndex.rawGetDictionary("TestTemplates");
                if (templateNames == null || templateNames.isEmpty()) continue;
                ArrayList<String> sortedTemplateNames = new ArrayList<String>(templateNames.keySet());
                Collections.sort(sortedTemplateNames);
                this.generateTestFile((STGroup)testIndex, targetGroup, testdir, sortedTemplateNames);
            }
        }
    }

    protected void generateTestFile(STGroup index, STGroup targetGroup, String testdir, Collection<String> testTemplates) {
        ErrorBuffer errors = new ErrorBuffer();
        targetGroup.setListener((STErrorListener)errors);
        File targetFolder = this.getOutputDir(testdir);
        String testName = testdir.substring(testdir.lastIndexOf(47) + 1);
        File targetFile = new File(targetFolder, "Test" + testName + ".java");
        ArrayList<ST> templates = new ArrayList<ST>();
        for (String template : testTemplates) {
            STGroupFile testGroup = new STGroupFile(testdir + "/" + template + STGroup.GROUP_FILE_EXTENSION);
            this.importLanguageTemplates((STGroup)testGroup, targetGroup);
            ST testType = testGroup.getInstanceOf("TestType");
            if (testType == null) {
                this.warn(String.format("Unable to generate tests for %s: no TestType specified.", template));
                continue;
            }
            ST testMethodTemplate = targetGroup.getInstanceOf(testType.render() + "TestMethod");
            if (testMethodTemplate == null) {
                this.warn(String.format("Unable to generate tests for %s: TestType '%s' is not supported by the current runtime.", template, testType.render()));
                continue;
            }
            testMethodTemplate.add((String)testMethodTemplate.impl.formalArguments.keySet().iterator().next(), (Object)testGroup);
            templates.add(testMethodTemplate);
        }
        ST testFileTemplate = targetGroup.getInstanceOf("TestFile");
        testFileTemplate.addAggr("file.{Options,name,tests}", new Object[]{index.rawGetDictionary("Options"), testName, templates});
        if (this.visualize) {
            STViz viz = testFileTemplate.inspect();
            try {
                viz.waitForClose();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            String output = testFileTemplate.render();
            if (errors.errors.size() > 0) {
                System.err.println("errors in " + targetGroup.getName() + ": " + String.valueOf(errors));
            }
            this.writeFile(targetFile, output);
        }
        catch (IOException ex) {
            this.error(String.format("Failed to write output file: %s", targetFile), ex);
        }
    }

    private void importLanguageTemplates(STGroup testGroup, STGroup languageGroup) {
        testGroup.load();
        if (testGroup == languageGroup) {
            assert (false) : "Attempted to import the language group into itself.";
            return;
        }
        if (testGroup.getImportedGroups().isEmpty()) {
            testGroup.importTemplates(languageGroup);
            return;
        }
        if (testGroup.getImportedGroups().contains(languageGroup)) {
            return;
        }
        for (STGroup importedGroup : testGroup.getImportedGroups()) {
            this.importLanguageTemplates(importedGroup, languageGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file, String content) throws IOException {
        file.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(file);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, this.encoding != null ? this.encoding : "UTF-8");){
            osw.write(content);
        }
    }

    public File getOutputDir(String templateFolder) {
        return new File(this.outputDirectory, templateFolder.substring(0, templateFolder.indexOf("/templates")));
    }

    protected void info(String message) {
        System.out.println("INFO: " + message);
    }

    protected void warn(String message) {
        System.err.println("WARNING: " + message);
    }

    protected void error(String message, Throwable throwable) {
        System.err.println("ERROR: " + message);
    }
}

