/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.support;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import java.util.regex.Pattern;
import lombok.Generated;

public class CompatibilityMode {
    private static final String VERSION8_1 = "Version8_1";
    private static final String DONT_USE = "DontUse";
    private static final int MAX_VERSION = 99;
    private static final int THIRD_VERSION = 3;
    private static final int VERSION_POSITION = 2;
    private static final Pattern VERSION_SPLITTER = Pattern.compile("([_.])");
    private static final int MAJOR = 8;
    private int minor;
    private int version;

    public CompatibilityMode() {
        this(DONT_USE);
    }

    public CompatibilityMode(String value) {
        if (value.equalsIgnoreCase(DONT_USE) || value.isEmpty()) {
            this.setVersionComponents(3, 99);
            return;
        }
        if (value.equals(VERSION8_1)) {
            this.setVersionComponents(1, 0);
            return;
        }
        String newValue = value.toUpperCase(Locale.ENGLISH).replace("VERSION_", "");
        String[] array = VERSION_SPLITTER.split(newValue);
        this.setVersionComponents(Integer.parseInt(array[1]), Integer.parseInt(array[2]));
    }

    public CompatibilityMode(int minor, int version) {
        this.setVersionComponents(minor, version);
    }

    public static int compareTo(CompatibilityMode versionA, CompatibilityMode versionB) {
        int result = 1;
        if (versionA.minor == versionB.minor) {
            if (versionA.version == versionB.version) {
                result = 0;
            } else if (versionA.version > versionB.version) {
                result = -1;
            }
        } else if (versionA.minor > versionB.minor) {
            result = -1;
        }
        return result;
    }

    public static int compareTo(CompatibilityMode versionA, String versionB) {
        return CompatibilityMode.compareTo(versionA, new CompatibilityMode(versionB));
    }

    private void setVersionComponents(int minor, int version) {
        this.minor = minor;
        this.version = version;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompatibilityMode)) {
            return false;
        }
        CompatibilityMode other = (CompatibilityMode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        return this.getVersion() == other.getVersion();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CompatibilityMode;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMinor();
        result = result * 59 + this.getVersion();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static int getMAJOR() {
        return 8;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMinor() {
        return this.minor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getVersion() {
        return this.version;
    }
}

