/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.types;

import com.github._1c_syntax.bsl.types.MDOType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public enum ModuleType {
    BotModule("Module.bsl"),
    IntegrationServiceModule("Module.bsl"),
    CommandModule("CommandModule.bsl"),
    CommonModule("Module.bsl"),
    ObjectModule("ObjectModule.bsl"),
    ManagerModule("ManagerModule.bsl"),
    FormModule("Module.bsl"),
    RecordSetModule("RecordSetModule.bsl"),
    ValueManagerModule("ValueManagerModule.bsl"),
    ApplicationModule("ApplicationModule.bsl"),
    ManagedApplicationModule("ManagedApplicationModule.bsl"),
    SessionModule("SessionModule.bsl"),
    ExternalConnectionModule("ExternalConnectionModule.bsl"),
    OrdinaryApplicationModule("OrdinaryApplicationModule.bsl"),
    HTTPServiceModule("Module.bsl"),
    WEBServiceModule("Module.bsl"),
    RecalculationModule("RecordSetModule.bsl"),
    OScriptClass("Class.os"),
    OScriptModule("Module.os"),
    UNKNOWN("");

    private static final Map<MDOType, Set<ModuleType>> MODULE_TYPES_FOR_MDO_TYPES;
    private static final List<ModuleType> OSCRIPT_MODULE_TYPES;
    private final String fileName;

    public static Set<ModuleType> byMDOType(MDOType mdoType) {
        return MODULE_TYPES_FOR_MDO_TYPES.getOrDefault((Object)mdoType, Collections.emptySet());
    }

    public static List<ModuleType> oScriptModuleTypes() {
        return OSCRIPT_MODULE_TYPES;
    }

    private static Map<MDOType, Set<ModuleType>> moduleTypesForMDOTypes() {
        EnumMap<MDOType, Set<ModuleType>> result = new EnumMap<MDOType, Set<ModuleType>>(MDOType.class);
        for (MDOType mdoType : MDOType.values()) {
            HashSet<ModuleType> types = new HashSet<ModuleType>();
            switch (mdoType) {
                case INTEGRATION_SERVICE: {
                    types.add(IntegrationServiceModule);
                    break;
                }
                case BOT: {
                    types.add(BotModule);
                    break;
                }
                case ACCOUNTING_REGISTER: 
                case ACCUMULATION_REGISTER: 
                case CALCULATION_REGISTER: 
                case INFORMATION_REGISTER: 
                case EXTERNAL_DATA_SOURCE_TABLE: {
                    types.add(ManagerModule);
                    types.add(RecordSetModule);
                    break;
                }
                case BUSINESS_PROCESS: 
                case CATALOG: 
                case CHART_OF_ACCOUNTS: 
                case CHART_OF_CALCULATION_TYPES: 
                case CHART_OF_CHARACTERISTIC_TYPES: 
                case DATA_PROCESSOR: 
                case DOCUMENT: 
                case EXCHANGE_PLAN: 
                case REPORT: 
                case TASK: {
                    types.add(ManagerModule);
                    types.add(ObjectModule);
                    break;
                }
                case COMMAND_GROUP: 
                case COMMON_ATTRIBUTE: 
                case COMMON_PICTURE: 
                case COMMON_TEMPLATE: 
                case DEFINED_TYPE: 
                case DOCUMENT_NUMERATOR: 
                case EVENT_SUBSCRIPTION: 
                case FUNCTIONAL_OPTION: 
                case ROLE: 
                case SCHEDULED_JOB: 
                case SESSION_PARAMETER: 
                case STYLE_ITEM: 
                case STYLE: 
                case SUBSYSTEM: 
                case WS_REFERENCE: 
                case XDTO_PACKAGE: {
                    break;
                }
                case COMMON_COMMAND: 
                case COMMAND: {
                    types.add(CommandModule);
                    break;
                }
                case COMMON_FORM: 
                case FORM: {
                    types.add(FormModule);
                    break;
                }
                case COMMON_MODULE: {
                    types.add(CommonModule);
                    break;
                }
                case CONFIGURATION: {
                    types.add(ApplicationModule);
                    types.add(SessionModule);
                    types.add(ExternalConnectionModule);
                    types.add(ManagedApplicationModule);
                    types.add(OrdinaryApplicationModule);
                    break;
                }
                case CONSTANT: {
                    types.add(ValueManagerModule);
                    types.add(ManagerModule);
                    break;
                }
                case DOCUMENT_JOURNAL: 
                case ENUM: 
                case FILTER_CRITERION: 
                case SETTINGS_STORAGE: {
                    types.add(ManagerModule);
                    break;
                }
                case HTTP_SERVICE: {
                    types.add(HTTPServiceModule);
                    break;
                }
                case SEQUENCE: {
                    types.add(RecordSetModule);
                    break;
                }
                case WEB_SERVICE: {
                    types.add(WEBServiceModule);
                    break;
                }
                case RECALCULATION: {
                    types.add(RecalculationModule);
                    break;
                }
                case EXTERNAL_DATA_PROCESSOR: 
                case EXTERNAL_REPORT: {
                    types.add(ObjectModule);
                    break;
                }
            }
            result.put(mdoType, types);
        }
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @ConstructorProperties(value={"fileName"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private ModuleType(String fileName) {
        this.fileName = fileName;
    }

    static {
        MODULE_TYPES_FOR_MDO_TYPES = ModuleType.moduleTypesForMDOTypes();
        OSCRIPT_MODULE_TYPES = List.of(OScriptClass, OScriptModule);
    }
}

