/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.types;

import com.github._1c_syntax.bsl.types.MDOType;
import com.github._1c_syntax.utils.StringInterner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public final class MdoReference
implements Comparable<MdoReference> {
    public static final MdoReference EMPTY = new MdoReference(MDOType.UNKNOWN, "", "");
    private static final String REF_SPLIT_REGEX = "\\.";
    private static final Pattern REF_SPLIT_PATTERN = Pattern.compile("\\.");
    private static final StringInterner stringInterner = new StringInterner();
    private static final Map<String, MdoReference> REFERENCES = new ConcurrentSkipListMap<String, MdoReference>(String.CASE_INSENSITIVE_ORDER);
    private final MDOType type;
    private final String mdoRef;
    private final String mdoRefRu;

    private MdoReference(MDOType type, String mdoRef, String mdoRefRu) {
        this.type = type;
        this.mdoRef = mdoRef;
        this.mdoRefRu = mdoRefRu;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static MdoReference create(@NonNull MDOType mdoType, @NonNull String mdoRef, @NonNull String mdoRefRu) {
        if (mdoType == null) {
            throw new NullPointerException("mdoType is marked non-null but is null");
        }
        if (mdoRef == null) {
            throw new NullPointerException("mdoRef is marked non-null but is null");
        }
        if (mdoRefRu == null) {
            throw new NullPointerException("mdoRefRu is marked non-null but is null");
        }
        return MdoReference.getOrCompute(mdoType, mdoRef, mdoRefRu);
    }

    public static MdoReference create(@NonNull MDOType mdoType, @NonNull String name) {
        if (mdoType == null) {
            throw new NullPointerException("mdoType is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String mdoRef = stringInterner.intern(mdoType.getName() + "." + name);
        String mdoRefRu = stringInterner.intern(mdoType.getNameRu() + "." + name);
        return MdoReference.getOrCompute(mdoType, mdoRef, mdoRefRu);
    }

    public static MdoReference create(@Nullable MdoReference mdoReferenceOwner, @NonNull MDOType mdoType, @NonNull String name) {
        if (mdoType == null) {
            throw new NullPointerException("mdoType is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (mdoReferenceOwner == null || mdoReferenceOwner.isEmpty()) {
            return MdoReference.create(mdoType, name);
        }
        String mdoRef = stringInterner.intern(mdoReferenceOwner.getMdoRef() + "." + mdoType.getName() + "." + name);
        String mdoRefRu = stringInterner.intern(mdoReferenceOwner.getMdoRefRu() + "." + mdoType.getNameRu() + "." + name);
        return MdoReference.getOrCompute(mdoType, mdoRef, mdoRefRu);
    }

    public static MdoReference create(@NonNull String fullName) {
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        String[] nameParts = REF_SPLIT_PATTERN.split(fullName);
        if (nameParts.length <= 1) {
            throw new IllegalArgumentException("Incorrect full name " + fullName);
        }
        MdoReference ref = null;
        int step = 2;
        for (int i = 0; i < nameParts.length; i += step) {
            Optional<MDOType> mdoType = MDOType.fromValue(nameParts[i]);
            if (mdoType.isEmpty()) continue;
            String mdoName = nameParts[i + 1];
            ref = ref == null ? MdoReference.create(mdoType.get(), mdoName) : MdoReference.create(ref, mdoType.get(), mdoName);
        }
        if (ref == null) {
            throw new IllegalArgumentException("Incorrect full name " + fullName);
        }
        return ref;
    }

    public static Optional<MdoReference> find(@NonNull String mdoRef) {
        if (mdoRef == null) {
            throw new NullPointerException("mdoRef is marked non-null but is null");
        }
        Optional<MdoReference> result = Optional.empty();
        if (REFERENCES.containsKey(mdoRef)) {
            result = Optional.of(REFERENCES.get(mdoRef));
        }
        return result;
    }

    @Override
    public int compareTo(@Nullable MdoReference mdoReference) {
        if (mdoReference == null) {
            return 1;
        }
        if (this.equals(mdoReference)) {
            return 0;
        }
        int typeComparison = this.type.compareTo(mdoReference.getType());
        if (typeComparison != 0) {
            return typeComparison;
        }
        int mdoRefComparison = this.mdoRef.compareTo(mdoReference.getMdoRef());
        if (mdoRefComparison != 0) {
            return mdoRefComparison;
        }
        return this.mdoRefRu.compareTo(mdoReference.getMdoRefRu());
    }

    private static MdoReference getOrCompute(@NonNull MDOType mdoType, @NonNull String mdoRef, @NonNull String mdoRefRu) {
        if (mdoType == null) {
            throw new NullPointerException("mdoType is marked non-null but is null");
        }
        if (mdoRef == null) {
            throw new NullPointerException("mdoRef is marked non-null but is null");
        }
        if (mdoRefRu == null) {
            throw new NullPointerException("mdoRefRu is marked non-null but is null");
        }
        if (REFERENCES.containsKey(mdoRef)) {
            return REFERENCES.get(mdoRef);
        }
        MdoReference newMdoReference = new MdoReference(mdoType, mdoRef, mdoRefRu);
        REFERENCES.put(newMdoReference.getMdoRef(), newMdoReference);
        REFERENCES.put(newMdoReference.getMdoRefRu(), newMdoReference);
        return newMdoReference;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MDOType getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMdoRef() {
        return this.mdoRef;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getMdoRefRu() {
        return this.mdoRefRu;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MdoReference)) {
            return false;
        }
        MdoReference other = (MdoReference)o;
        String this$mdoRef = this.getMdoRef();
        String other$mdoRef = other.getMdoRef();
        return !(this$mdoRef == null ? other$mdoRef != null : !this$mdoRef.equals(other$mdoRef));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mdoRef = this.getMdoRef();
        result = result * 59 + ($mdoRef == null ? 43 : $mdoRef.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "MdoReference(mdoRef=" + this.getMdoRef() + ")";
    }
}

