/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.BSLTextDocumentService;
import com.github._1c_syntax.bsl.languageserver.BSLWorkspaceService;
import com.github._1c_syntax.bsl.languageserver.ClientCapabilitiesHolder;
import com.github._1c_syntax.bsl.languageserver.aop.EventPublisherAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.DiagnosticParams;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.Diagnostics;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.ProtocolExtension;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.CallHierarchyRegistrationOptions;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.ColorProviderOptions;
import org.eclipse.lsp4j.DefinitionOptions;
import org.eclipse.lsp4j.DocumentFormattingOptions;
import org.eclipse.lsp4j.DocumentLinkOptions;
import org.eclipse.lsp4j.DocumentRangeFormattingOptions;
import org.eclipse.lsp4j.DocumentSymbolOptions;
import org.eclipse.lsp4j.FoldingRangeProviderOptions;
import org.eclipse.lsp4j.HoverOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ReferenceOptions;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.SelectionRangeRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceSymbolOptions;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BSLLanguageServer
implements LanguageServer,
ProtocolExtension {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private final LanguageServerConfiguration configuration;
    private final BSLTextDocumentService textDocumentService;
    private final BSLWorkspaceService workspaceService;
    private final ClientCapabilitiesHolder clientCapabilitiesHolder;
    private final ServerContext context;
    private final ServerInfo serverInfo;
    private boolean shutdownWasCalled;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        InitializeParams initializeParams = params;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)initializeParams);
        this.clientCapabilitiesHolder.setCapabilities(params.getCapabilities());
        this.setConfigurationRoot(params);
        CompletableFuture.runAsync(this.context::populateContext);
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(BSLLanguageServer.getTextDocumentSyncOptions());
        capabilities.setDocumentRangeFormattingProvider(BSLLanguageServer.getDocumentRangeFormattingProvider());
        capabilities.setDocumentFormattingProvider(BSLLanguageServer.getDocumentFormattingProvider());
        capabilities.setFoldingRangeProvider(BSLLanguageServer.getFoldingRangeProvider());
        capabilities.setDocumentSymbolProvider(BSLLanguageServer.getDocumentSymbolProvider());
        capabilities.setCodeActionProvider(BSLLanguageServer.getCodeActionProvider());
        capabilities.setCodeLensProvider(BSLLanguageServer.getCodeLensProvider());
        capabilities.setDocumentLinkProvider(BSLLanguageServer.getDocumentLinkProvider());
        capabilities.setWorkspaceSymbolProvider(BSLLanguageServer.getWorkspaceProvider());
        capabilities.setHoverProvider(BSLLanguageServer.getHoverProvider());
        capabilities.setReferencesProvider(BSLLanguageServer.getReferencesProvider());
        capabilities.setDefinitionProvider(BSLLanguageServer.getDefinitionProvider());
        capabilities.setCallHierarchyProvider(BSLLanguageServer.getCallHierarchyProvider());
        capabilities.setSelectionRangeProvider(BSLLanguageServer.getSelectionRangeProvider());
        capabilities.setColorProvider(BSLLanguageServer.getColorProvider());
        InitializeResult result = new InitializeResult(capabilities, this.serverInfo);
        CompletableFuture<InitializeResult> completableFuture = CompletableFuture.completedFuture(result);
        EventPublisherAspect.aspectOf().languageServerInitialize(joinPoint, initializeParams);
        return completableFuture;
    }

    private void setConfigurationRoot(InitializeParams params) {
        Path rootPath;
        List workspaceFolders = params.getWorkspaceFolders();
        if (workspaceFolders == null || workspaceFolders.isEmpty()) {
            return;
        }
        String rootUri = ((WorkspaceFolder)workspaceFolders.get(0)).getUri();
        try {
            rootPath = new File(new URI(rootUri).getPath()).getCanonicalFile().toPath();
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("Can't read root URI from initialization params.", (Throwable)e);
            return;
        }
        Path configurationRoot = LanguageServerConfiguration.getCustomConfigurationRoot(this.configuration, rootPath);
        this.context.setConfigurationRoot(configurationRoot);
    }

    public CompletableFuture<Object> shutdown() {
        this.shutdownWasCalled = true;
        this.textDocumentService.reset();
        this.context.clear();
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    public void exit() {
        int status = this.shutdownWasCalled ? 0 : 1;
        System.exit(status);
    }

    @Override
    public CompletableFuture<Diagnostics> diagnostics(DiagnosticParams params) {
        return this.textDocumentService.diagnostics(params);
    }

    public TextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    private static TextDocumentSyncOptions getTextDocumentSyncOptions() {
        TextDocumentSyncOptions textDocumentSync = new TextDocumentSyncOptions();
        textDocumentSync.setOpenClose(Boolean.TRUE);
        textDocumentSync.setChange(TextDocumentSyncKind.Full);
        textDocumentSync.setWillSave(Boolean.FALSE);
        textDocumentSync.setWillSaveWaitUntil(Boolean.FALSE);
        SaveOptions save = new SaveOptions();
        save.setIncludeText(Boolean.FALSE);
        textDocumentSync.setSave(save);
        return textDocumentSync;
    }

    private static CodeActionOptions getCodeActionProvider() {
        CodeActionOptions codeActionOptions = new CodeActionOptions();
        codeActionOptions.setWorkDoneProgress(Boolean.FALSE);
        codeActionOptions.setResolveProvider(Boolean.FALSE);
        List<String> codeActionKinds = List.of("quickfix", "refactor");
        codeActionOptions.setCodeActionKinds(codeActionKinds);
        return codeActionOptions;
    }

    private static DocumentSymbolOptions getDocumentSymbolProvider() {
        DocumentSymbolOptions documentSymbolOptions = new DocumentSymbolOptions();
        documentSymbolOptions.setWorkDoneProgress(Boolean.FALSE);
        documentSymbolOptions.setLabel("BSL Language Server");
        return documentSymbolOptions;
    }

    private static FoldingRangeProviderOptions getFoldingRangeProvider() {
        FoldingRangeProviderOptions foldingRangeProviderOptions = new FoldingRangeProviderOptions();
        foldingRangeProviderOptions.setWorkDoneProgress(Boolean.FALSE);
        return foldingRangeProviderOptions;
    }

    private static DocumentFormattingOptions getDocumentFormattingProvider() {
        DocumentFormattingOptions documentFormattingOptions = new DocumentFormattingOptions();
        documentFormattingOptions.setWorkDoneProgress(Boolean.FALSE);
        return documentFormattingOptions;
    }

    private static DocumentRangeFormattingOptions getDocumentRangeFormattingProvider() {
        DocumentRangeFormattingOptions documentRangeFormattingOptions = new DocumentRangeFormattingOptions();
        documentRangeFormattingOptions.setWorkDoneProgress(Boolean.FALSE);
        return documentRangeFormattingOptions;
    }

    private static CodeLensOptions getCodeLensProvider() {
        CodeLensOptions codeLensOptions = new CodeLensOptions();
        codeLensOptions.setResolveProvider(Boolean.TRUE);
        codeLensOptions.setWorkDoneProgress(Boolean.FALSE);
        return codeLensOptions;
    }

    private static DocumentLinkOptions getDocumentLinkProvider() {
        DocumentLinkOptions documentLinkOptions = new DocumentLinkOptions();
        documentLinkOptions.setResolveProvider(Boolean.FALSE);
        return documentLinkOptions;
    }

    private static HoverOptions getHoverProvider() {
        HoverOptions hoverOptions = new HoverOptions();
        hoverOptions.setWorkDoneProgress(Boolean.FALSE);
        return hoverOptions;
    }

    private static DefinitionOptions getDefinitionProvider() {
        DefinitionOptions definitionOptions = new DefinitionOptions();
        definitionOptions.setWorkDoneProgress(Boolean.FALSE);
        return definitionOptions;
    }

    private static ReferenceOptions getReferencesProvider() {
        ReferenceOptions referenceOptions = new ReferenceOptions();
        referenceOptions.setWorkDoneProgress(Boolean.FALSE);
        return referenceOptions;
    }

    private static CallHierarchyRegistrationOptions getCallHierarchyProvider() {
        CallHierarchyRegistrationOptions callHierarchyRegistrationOptions = new CallHierarchyRegistrationOptions();
        callHierarchyRegistrationOptions.setWorkDoneProgress(Boolean.FALSE);
        return callHierarchyRegistrationOptions;
    }

    private static WorkspaceSymbolOptions getWorkspaceProvider() {
        WorkspaceSymbolOptions workspaceSymbolOptions = new WorkspaceSymbolOptions();
        workspaceSymbolOptions.setWorkDoneProgress(Boolean.FALSE);
        return workspaceSymbolOptions;
    }

    private static SelectionRangeRegistrationOptions getSelectionRangeProvider() {
        SelectionRangeRegistrationOptions selectionRangeRegistrationOptions = new SelectionRangeRegistrationOptions();
        selectionRangeRegistrationOptions.setWorkDoneProgress(Boolean.FALSE);
        return selectionRangeRegistrationOptions;
    }

    private static ColorProviderOptions getColorProvider() {
        ColorProviderOptions colorProviderOptions = new ColorProviderOptions();
        colorProviderOptions.setWorkDoneProgress(Boolean.FALSE);
        return colorProviderOptions;
    }

    @ConstructorProperties(value={"configuration", "textDocumentService", "workspaceService", "clientCapabilitiesHolder", "context", "serverInfo"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLLanguageServer(LanguageServerConfiguration configuration, BSLTextDocumentService textDocumentService, BSLWorkspaceService workspaceService, ClientCapabilitiesHolder clientCapabilitiesHolder, ServerContext context, ServerInfo serverInfo) {
        this.configuration = configuration;
        this.textDocumentService = textDocumentService;
        this.workspaceService = workspaceService;
        this.clientCapabilitiesHolder = clientCapabilitiesHolder;
        this.context = context;
        this.serverInfo = serverInfo;
    }

    static {
        BSLLanguageServer.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(BSLLanguageServer.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BSLLanguageServer.java", BSLLanguageServer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initialize", "com.github._1c_syntax.bsl.languageserver.BSLLanguageServer", "org.eclipse.lsp4j.InitializeParams", "params", "", "java.util.concurrent.CompletableFuture"), 83);
    }
}

