/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.codelenses.CodeLensData;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.configuration.diagnostics.ComputeTrigger;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.DiagnosticParams;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.Diagnostics;
import com.github._1c_syntax.bsl.languageserver.jsonrpc.ProtocolExtension;
import com.github._1c_syntax.bsl.languageserver.providers.CallHierarchyProvider;
import com.github._1c_syntax.bsl.languageserver.providers.CodeActionProvider;
import com.github._1c_syntax.bsl.languageserver.providers.CodeLensProvider;
import com.github._1c_syntax.bsl.languageserver.providers.ColorProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DefinitionProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DiagnosticProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DocumentLinkProvider;
import com.github._1c_syntax.bsl.languageserver.providers.DocumentSymbolProvider;
import com.github._1c_syntax.bsl.languageserver.providers.FoldingRangeProvider;
import com.github._1c_syntax.bsl.languageserver.providers.FormatProvider;
import com.github._1c_syntax.bsl.languageserver.providers.HoverProvider;
import com.github._1c_syntax.bsl.languageserver.providers.ReferencesProvider;
import com.github._1c_syntax.bsl.languageserver.providers.SelectionRangeProvider;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.eclipse.lsp4j.CallHierarchyIncomingCall;
import org.eclipse.lsp4j.CallHierarchyIncomingCallsParams;
import org.eclipse.lsp4j.CallHierarchyItem;
import org.eclipse.lsp4j.CallHierarchyOutgoingCall;
import org.eclipse.lsp4j.CallHierarchyOutgoingCallsParams;
import org.eclipse.lsp4j.CallHierarchyPrepareParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.SelectionRange;
import org.eclipse.lsp4j.SelectionRangeParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.springframework.stereotype.Component;

@Component
public class BSLTextDocumentService
implements TextDocumentService,
ProtocolExtension {
    private final ServerContext context;
    private final LanguageServerConfiguration configuration;
    private final DiagnosticProvider diagnosticProvider;
    private final CodeActionProvider codeActionProvider;
    private final CodeLensProvider codeLensProvider;
    private final DocumentLinkProvider documentLinkProvider;
    private final DocumentSymbolProvider documentSymbolProvider;
    private final FoldingRangeProvider foldingRangeProvider;
    private final FormatProvider formatProvider;
    private final HoverProvider hoverProvider;
    private final ReferencesProvider referencesProvider;
    private final DefinitionProvider definitionProvider;
    private final CallHierarchyProvider callHierarchyProvider;
    private final SelectionRangeProvider selectionRangeProvider;
    private final ColorProvider colorProvider;

    public CompletableFuture<Hover> hover(HoverParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.hoverProvider.getHover(documentContext, params).orElse(null));
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Either.forRight(Collections.emptyList()));
        }
        return CompletableFuture.supplyAsync(() -> Either.forRight(this.definitionProvider.getDefinition(documentContext, params)));
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.referencesProvider.getReferences(documentContext, params));
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.documentSymbolProvider.getDocumentSymbols(documentContext));
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.codeActionProvider.getCodeActions(params, documentContext));
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.codeLensProvider.getCodeLens(documentContext));
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        CodeLensData data = this.codeLensProvider.extractData(unresolved);
        DocumentContext documentContext = this.context.getDocument(data.getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(unresolved);
        }
        return CompletableFuture.supplyAsync(() -> this.codeLensProvider.resolveCodeLens(documentContext, unresolved, data));
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        List<TextEdit> edits = this.formatProvider.getFormatting(params, documentContext);
        return CompletableFuture.completedFuture(edits);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        List<TextEdit> edits = this.formatProvider.getRangeFormatting(params, documentContext);
        return CompletableFuture.completedFuture(edits);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.foldingRangeProvider.getFoldingRange(documentContext));
    }

    public CompletableFuture<List<CallHierarchyItem>> prepareCallHierarchy(CallHierarchyPrepareParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<CallHierarchyItem> callHierarchyItems = this.callHierarchyProvider.prepareCallHierarchy(documentContext, params);
            if (callHierarchyItems.isEmpty()) {
                return null;
            }
            return callHierarchyItems;
        });
    }

    public CompletableFuture<List<CallHierarchyIncomingCall>> callHierarchyIncomingCalls(CallHierarchyIncomingCallsParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getItem().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.callHierarchyProvider.incomingCalls(documentContext, params));
    }

    public CompletableFuture<List<CallHierarchyOutgoingCall>> callHierarchyOutgoingCalls(CallHierarchyOutgoingCallsParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getItem().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.callHierarchyProvider.outgoingCalls(documentContext, params));
    }

    public CompletableFuture<List<SelectionRange>> selectionRange(SelectionRangeParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.selectionRangeProvider.getSelectionRange(documentContext, params));
    }

    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.colorProvider.getDocumentColor(documentContext));
    }

    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return CompletableFuture.supplyAsync(() -> this.colorProvider.getColorPresentation(documentContext, params));
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        DocumentContext documentContext = this.context.addDocument(params.getTextDocument());
        if (this.configuration.getDiagnosticsOptions().getComputeTrigger() != ComputeTrigger.NEVER) {
            this.validate(documentContext);
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return;
        }
        documentContext.rebuild(((TextDocumentContentChangeEvent)params.getContentChanges().get(0)).getText(), params.getTextDocument().getVersion());
        if (this.configuration.getDiagnosticsOptions().getComputeTrigger() == ComputeTrigger.ONTYPE) {
            this.validate(documentContext);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return;
        }
        documentContext.clearSecondaryData();
        this.diagnosticProvider.publishEmptyDiagnosticList(documentContext);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return;
        }
        if (this.configuration.getDiagnosticsOptions().getComputeTrigger() != ComputeTrigger.NEVER) {
            this.validate(documentContext);
        }
    }

    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.supplyAsync(() -> this.documentLinkProvider.getDocumentLinks(documentContext));
    }

    @Override
    public CompletableFuture<Diagnostics> diagnostics(DiagnosticParams params) {
        DocumentContext documentContext = this.context.getDocument(params.getTextDocument().getUri());
        if (documentContext == null) {
            return CompletableFuture.completedFuture(Diagnostics.EMPTY);
        }
        return CompletableFuture.supplyAsync(() -> {
            List<Object> diagnostics = documentContext.getDiagnostics();
            Range range = params.getRange();
            if (range != null) {
                diagnostics = diagnostics.stream().filter(diagnostic -> Ranges.containsRange(range, diagnostic.getRange())).collect(Collectors.toList());
            }
            return new Diagnostics(diagnostics, documentContext.getVersion());
        });
    }

    public void reset() {
        this.context.clear();
    }

    private void validate(DocumentContext documentContext) {
        this.diagnosticProvider.computeAndPublishDiagnostics(documentContext);
    }

    @ConstructorProperties(value={"context", "configuration", "diagnosticProvider", "codeActionProvider", "codeLensProvider", "documentLinkProvider", "documentSymbolProvider", "foldingRangeProvider", "formatProvider", "hoverProvider", "referencesProvider", "definitionProvider", "callHierarchyProvider", "selectionRangeProvider", "colorProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLTextDocumentService(ServerContext context, LanguageServerConfiguration configuration, DiagnosticProvider diagnosticProvider, CodeActionProvider codeActionProvider, CodeLensProvider codeLensProvider, DocumentLinkProvider documentLinkProvider, DocumentSymbolProvider documentSymbolProvider, FoldingRangeProvider foldingRangeProvider, FormatProvider formatProvider, HoverProvider hoverProvider, ReferencesProvider referencesProvider, DefinitionProvider definitionProvider, CallHierarchyProvider callHierarchyProvider, SelectionRangeProvider selectionRangeProvider, ColorProvider colorProvider) {
        this.context = context;
        this.configuration = configuration;
        this.diagnosticProvider = diagnosticProvider;
        this.codeActionProvider = codeActionProvider;
        this.codeLensProvider = codeLensProvider;
        this.documentLinkProvider = documentLinkProvider;
        this.documentSymbolProvider = documentSymbolProvider;
        this.foldingRangeProvider = foldingRangeProvider;
        this.formatProvider = formatProvider;
        this.hoverProvider = hoverProvider;
        this.referencesProvider = referencesProvider;
        this.definitionProvider = definitionProvider;
        this.callHierarchyProvider = callHierarchyProvider;
        this.selectionRangeProvider = selectionRangeProvider;
        this.colorProvider = colorProvider;
    }
}

