/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.cli.lsp;

import com.github._1c_syntax.bsl.languageserver.configuration.events.LanguageServerConfigurationChangedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.CheckForNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class FileAwarePrintWriter
extends PrintWriter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAwarePrintWriter.class);
    private boolean isEmpty = true;
    private File file;

    public FileAwarePrintWriter() {
        super(OutputStream.nullOutputStream(), false, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(@CheckForNull File file) {
        Object object = this.lock;
        synchronized (object) {
            FileOutputStream fileOutputStream;
            if (Objects.equals(file, this.file)) {
                return;
            }
            this.file = file;
            if (file == null) {
                this.closeOutputStream();
                return;
            }
            if (file.isDirectory()) {
                LOGGER.error("Trace log setting must lead to file, not directory! {}", (Object)file.getAbsolutePath());
                return;
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Can't create LSP trace file", (Throwable)e);
                return;
            }
            this.closeOutputStream();
            this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8));
            this.lock = this.out;
            this.isEmpty = false;
        }
    }

    @Override
    public void print(String s) {
        if (this.isEmpty) {
            return;
        }
        super.print(s);
    }

    @Override
    public void flush() {
        if (this.isEmpty) {
            return;
        }
        super.flush();
    }

    @EventListener
    public void handleEvent(LanguageServerConfigurationChangedEvent event) {
        this.setFile(event.getSource().getTraceLog());
    }

    private void closeOutputStream() {
        this.out.close();
        this.isEmpty = true;
    }
}

