/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.utils.Regions;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class GenerateStandardRegionsSupplier
implements CodeActionSupplier {
    private final LanguageServerConfiguration languageServerConfiguration;

    public GenerateStandardRegionsSupplier(LanguageServerConfiguration languageServerConfiguration) {
        this.languageServerConfiguration = languageServerConfiguration;
    }

    @Override
    public List<CodeAction> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        ModuleType moduleType = documentContext.getModuleType();
        FileType fileType = documentContext.getFileType();
        ScriptVariant regionsLanguage = this.getRegionsLanguage(documentContext, fileType);
        Set<String> neededStandardRegions = fileType == FileType.BSL ? Regions.getStandardRegionsNamesByModuleType(moduleType, regionsLanguage) : Regions.getOneScriptStandardRegions(regionsLanguage);
        Set documentRegionsNames = documentContext.getSymbolTree().getModuleLevelRegions().stream().map(RegionSymbol::getName).collect(Collectors.toSet());
        neededStandardRegions.removeAll(documentRegionsNames);
        if (neededStandardRegions.isEmpty()) {
            return Collections.emptyList();
        }
        String regionFormat = regionsLanguage == ScriptVariant.ENGLISH ? "#Region %s%n%n#EndRegion%n" : "#\u041e\u0431\u043b\u0430\u0441\u0442\u044c %s%n%n#\u041a\u043e\u043d\u0435\u0446\u041e\u0431\u043b\u0430\u0441\u0442\u0438%n";
        String result = neededStandardRegions.stream().map(s -> String.format(regionFormat, s)).collect(Collectors.joining("\n"));
        TextEdit textEdit = new TextEdit(this.calculateFixRange(params.getRange()), result);
        WorkspaceEdit edit = new WorkspaceEdit();
        Map<String, List<TextEdit>> changes = Map.of(documentContext.getUri().toString(), Collections.singletonList(textEdit));
        edit.setChanges(changes);
        CodeAction codeAction = new CodeAction("Generate missing regions");
        codeAction.setDiagnostics(new ArrayList());
        codeAction.setKind("refactor");
        codeAction.setEdit(edit);
        return List.of(codeAction);
    }

    private ScriptVariant getRegionsLanguage(DocumentContext documentContext, FileType fileType) {
        Configuration configuration = documentContext.getServerContext().getConfiguration();
        ScriptVariant regionsLanguage = configuration.getConfigurationSource() == ConfigurationSource.EMPTY || fileType == FileType.OS ? this.getScriptVariantFromConfigLanguage() : documentContext.getServerContext().getConfiguration().getScriptVariant();
        return regionsLanguage;
    }

    @NotNull
    private ScriptVariant getScriptVariantFromConfigLanguage() {
        ScriptVariant regionsLanguage = this.languageServerConfiguration.getLanguage() == Language.EN ? ScriptVariant.ENGLISH : ScriptVariant.RUSSIAN;
        return regionsLanguage;
    }

    private Range calculateFixRange(Range range) {
        Position start = range.getStart();
        if (start == null) {
            start = new Position(0, 0);
        } else {
            start.setCharacter(0);
        }
        Position end = range.getEnd();
        if (end == null) {
            end = new Position(0, 0);
        } else {
            end.setCharacter(0);
        }
        range.setStart(start);
        range.setEnd(end);
        return range;
    }
}

