/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.color;

import com.github._1c_syntax.bsl.languageserver.color.ColorInformationSupplier;
import com.github._1c_syntax.bsl.languageserver.color.WebColor;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.Color;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.Range;
import org.springframework.stereotype.Component;

@Component
public class WebColorInformationSupplier
implements ColorInformationSupplier {
    private static final Pattern WEB_COLOR_PATTERN = CaseInsensitivePattern.compile((String)"^(?:Web\u0426\u0432\u0435\u0442\u0430|WebColors)$");
    private static final Map<String, WebColor> WEB_COLORS = WebColorInformationSupplier.createWebColors();

    @Override
    public List<ColorInformation> getColorInformation(DocumentContext documentContext) {
        Collection<ParseTree> complexIdentifiers = Trees.findAllRuleNodes((ParseTree)documentContext.getAst(), 92);
        return complexIdentifiers.stream().map(BSLParser.ComplexIdentifierContext.class::cast).filter(complexIdentifier -> complexIdentifier.IDENTIFIER() != null).filter(complexIdentifier -> complexIdentifier.modifier().size() == 1).filter(complexIdentifier -> complexIdentifier.modifier(0).accessProperty() != null).filter(complexIdentifier -> WEB_COLOR_PATTERN.matcher(complexIdentifier.IDENTIFIER().getText()).matches()).map(WebColorInformationSupplier::toColorInformation).collect(Collectors.toList());
    }

    private static ColorInformation toColorInformation(BSLParser.ComplexIdentifierContext ctx) {
        String colorName = ctx.modifier(0).accessProperty().IDENTIFIER().getText();
        WebColor webColor = WEB_COLORS.get(colorName);
        double red = (double)webColor.getRed() / 255.0;
        double green = (double)webColor.getGreen() / 255.0;
        double blue = (double)webColor.getBlue() / 255.0;
        Range range = Ranges.create((ParserRuleContext)ctx);
        Color color = new Color(red, green, blue, 1.0);
        return new ColorInformation(range, color);
    }

    private static Map<String, WebColor> createWebColors() {
        TreeMap<String, WebColor> colors = new TreeMap<String, WebColor>(String.CASE_INSENSITIVE_ORDER);
        for (WebColor color : WebColor.values()) {
            colors.put(color.getRu(), color);
            colors.put(color.getEn(), color);
        }
        return colors;
    }
}

