/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.configuration.databind;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersDeserializer
extends JsonDeserializer<Map<String, Either<Boolean, Map<String, Object>>>> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ParametersDeserializer.class);

    public Map<String, Either<Boolean, Map<String, Object>>> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        JsonNode parameters = (JsonNode)p.getCodec().readTree(p);
        if (parameters == null) {
            return Collections.emptyMap();
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Either<Boolean, Map<String, Object>>> parametersMap = new HashMap<String, Either<Boolean, Map<String, Object>>>();
        Iterator parametersNodes = parameters.fields();
        parametersNodes.forEachRemaining(entry -> {
            JsonNode parameterConfig = (JsonNode)entry.getValue();
            if (parameterConfig.isBoolean()) {
                parametersMap.put((String)entry.getKey(), Either.forLeft((Object)parameterConfig.asBoolean()));
            } else {
                Map<String, Object> parameterConfiguration = ParametersDeserializer.getParameterConfiguration(mapper, (JsonNode)entry.getValue());
                parametersMap.put((String)entry.getKey(), Either.forRight(parameterConfiguration));
            }
        });
        return parametersMap;
    }

    private static Map<String, Object> getParameterConfiguration(ObjectMapper mapper, JsonNode parameterConfig) {
        Map parameterConfiguration;
        try {
            JavaType type = mapper.getTypeFactory().constructType((TypeReference)new TypeReference<Map<String, Object>>(){});
            parameterConfiguration = (Map)mapper.readValue(mapper.treeAsTokens((TreeNode)parameterConfig), type);
        }
        catch (IOException e) {
            LOGGER.error("Can't deserialize parameter configuration", (Throwable)e);
            return Collections.emptyMap();
        }
        return parameterConfiguration;
    }
}

