/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context;

import com.github._1c_syntax.bsl.languageserver.aop.EventPublisherAspect;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.FileType;
import com.github._1c_syntax.bsl.languageserver.context.MetricStorage;
import com.github._1c_syntax.bsl.languageserver.context.ServerContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.CognitiveComplexityComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.ComplexityData;
import com.github._1c_syntax.bsl.languageserver.context.computer.CyclomaticComplexityComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.QueryComputer;
import com.github._1c_syntax.bsl.languageserver.context.computer.SymbolTreeComputer;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.SymbolTree;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLTokenizer;
import com.github._1c_syntax.bsl.parser.SDBLTokenizer;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.mdo.support.ScriptVariant;
import com.github._1c_syntax.mdclasses.supportconf.SupportConfiguration;
import com.github._1c_syntax.mdclasses.supportconf.SupportVariant;
import com.github._1c_syntax.utils.Lazy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DocumentContext {
    private static final Pattern CONTENT_SPLIT_PATTERN;
    private final URI uri;
    @Nullable
    private String content;
    private int version;
    private ServerContext context;
    private DiagnosticComputer diagnosticComputer;
    private LanguageServerConfiguration configuration;
    private FileType fileType;
    private BSLTokenizer tokenizer;
    private final ReentrantLock computeLock = new ReentrantLock();
    private final ReentrantLock diagnosticsLock = new ReentrantLock();
    private final Lazy<String[]> contentList = new Lazy(this::computeContentList, this.computeLock);
    private final Lazy<ModuleType> moduleType = new Lazy(this::computeModuleType, this.computeLock);
    private final Lazy<Map<SupportConfiguration, SupportVariant>> supportVariants = new Lazy(this::computeSupportVariants, this.computeLock);
    private final Lazy<SymbolTree> symbolTree = new Lazy(this::computeSymbolTree, this.computeLock);
    private final Lazy<ComplexityData> cognitiveComplexityData = new Lazy(this::computeCognitiveComplexity, this.computeLock);
    private final Lazy<ComplexityData> cyclomaticComplexityData = new Lazy(this::computeCyclomaticComplexity, this.computeLock);
    private final Lazy<DiagnosticIgnoranceComputer.Data> diagnosticIgnoranceData = new Lazy(this::computeDiagnosticIgnorance, this.computeLock);
    private final Lazy<MetricStorage> metrics = new Lazy(this::computeMetrics, this.computeLock);
    private final Lazy<List<Diagnostic>> diagnostics = new Lazy(this::computeDiagnostics, this.diagnosticsLock);
    private final Lazy<List<SDBLTokenizer>> queries = new Lazy(this::computeQueries, this.computeLock);
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    void init() {
        this.fileType = DocumentContext.computeFileType(this.uri);
    }

    public ServerContext getServerContext() {
        return this.context;
    }

    public String getContent() {
        Objects.requireNonNull(this.content);
        return this.content;
    }

    public String[] getContentList() {
        return (String[])this.contentList.getOrCompute();
    }

    public BSLParser.FileContext getAst() {
        Objects.requireNonNull(this.content);
        return (BSLParser.FileContext)this.tokenizer.getAst();
    }

    public SymbolTree getSymbolTree() {
        return (SymbolTree)this.symbolTree.getOrCompute();
    }

    public List<Token> getTokens() {
        Objects.requireNonNull(this.content);
        return this.tokenizer.getTokens();
    }

    public List<Token> getTokensFromDefaultChannel() {
        return this.getTokens().stream().filter(token -> token.getChannel() == 0).collect(Collectors.toList());
    }

    public List<Token> getComments() {
        return this.getTokens().stream().filter(token -> token.getType() == 1).collect(Collectors.toList());
    }

    public String getText(Range range) {
        Position start = range.getStart();
        Position end = range.getEnd();
        String[] contentListUnboxed = this.getContentList();
        if (start.getLine() > contentListUnboxed.length || end.getLine() > contentListUnboxed.length) {
            throw new ArrayIndexOutOfBoundsException("Range goes beyond the boundaries of the parsed document");
        }
        String startString = contentListUnboxed[start.getLine()];
        StringBuilder sb = new StringBuilder();
        if (start.getLine() == end.getLine()) {
            sb.append(startString, start.getCharacter(), end.getCharacter());
        } else {
            sb.append(startString.substring(start.getCharacter())).append("\n");
        }
        for (int i = start.getLine() + 1; i <= end.getLine() - 1; ++i) {
            sb.append(contentListUnboxed[i]).append("\n");
        }
        if (start.getLine() != end.getLine()) {
            sb.append(contentListUnboxed[end.getLine()], 0, end.getCharacter());
        }
        return sb.toString();
    }

    public Locale getScriptVariantLocale() {
        String languageTag;
        Configuration mdConfiguration = this.getServerContext().getConfiguration();
        if (mdConfiguration.getConfigurationSource() == ConfigurationSource.EMPTY || this.fileType == FileType.OS) {
            languageTag = this.configuration.getLanguage().getLanguageCode();
        } else {
            ScriptVariant scriptVariant = mdConfiguration.getScriptVariant();
            if (scriptVariant == ScriptVariant.ENGLISH) {
                languageTag = "en";
            } else if (scriptVariant == ScriptVariant.RUSSIAN) {
                languageTag = "ru";
            } else {
                throw new IllegalArgumentException("Unknown scriptVariant " + scriptVariant);
            }
        }
        return Locale.forLanguageTag(languageTag);
    }

    public MetricStorage getMetrics() {
        return (MetricStorage)this.metrics.getOrCompute();
    }

    public URI getUri() {
        return this.uri;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public ComplexityData getCognitiveComplexityData() {
        return (ComplexityData)this.cognitiveComplexityData.getOrCompute();
    }

    public ComplexityData getCyclomaticComplexityData() {
        return (ComplexityData)this.cyclomaticComplexityData.getOrCompute();
    }

    public DiagnosticIgnoranceComputer.Data getDiagnosticIgnorance() {
        return (DiagnosticIgnoranceComputer.Data)this.diagnosticIgnoranceData.getOrCompute();
    }

    public ModuleType getModuleType() {
        return (ModuleType)this.moduleType.getOrCompute();
    }

    public Map<SupportConfiguration, SupportVariant> getSupportVariants() {
        return (Map)this.supportVariants.getOrCompute();
    }

    public Optional<AbstractMDObjectBase> getMdObject() {
        return Optional.ofNullable((AbstractMDObjectBase)this.getServerContext().getConfiguration().getModulesByObject().get(this.getUri()));
    }

    public List<SDBLTokenizer> getQueries() {
        return (List)this.queries.getOrCompute();
    }

    public List<Diagnostic> getDiagnostics() {
        return (List)this.diagnostics.getOrCompute();
    }

    public List<Diagnostic> getComputedDiagnostics() {
        return Optional.ofNullable((List)this.diagnostics.get()).orElseGet(Collections::emptyList);
    }

    public void rebuild(String content, int version) {
        boolean contentWasCleared;
        String string = content;
        int n = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        this.computeLock.lock();
        boolean versionMatches = version == this.version && version != 0;
        boolean bl = contentWasCleared = this.content == null;
        if (versionMatches && !contentWasCleared) {
            this.clearDependantData();
            this.computeLock.unlock();
        } else {
            this.clearSecondaryData();
            this.symbolTree.clear();
            this.content = content;
            this.tokenizer = new BSLTokenizer(content);
            this.version = version;
            this.computeLock.unlock();
        }
        EventPublisherAspect.aspectOf().documentContextRebuild(joinPoint);
    }

    public void clearSecondaryData() {
        this.computeLock.lock();
        this.content = null;
        this.contentList.clear();
        this.tokenizer = null;
        this.cognitiveComplexityData.clear();
        this.cyclomaticComplexityData.clear();
        this.metrics.clear();
        this.diagnosticIgnoranceData.clear();
        this.queries.clear();
        this.clearDependantData();
        this.computeLock.unlock();
    }

    private void clearDependantData() {
        this.computeLock.lock();
        this.diagnosticsLock.lock();
        this.diagnostics.clear();
        this.diagnosticsLock.unlock();
        this.computeLock.unlock();
    }

    private static FileType computeFileType(URI uri) {
        FileType fileTypeFromUri;
        String uriPath = uri.getPath();
        if (uriPath == null) {
            return FileType.BSL;
        }
        try {
            fileTypeFromUri = FileType.valueOf(FilenameUtils.getExtension((String)uriPath).toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ignored) {
            fileTypeFromUri = FileType.BSL;
        }
        return fileTypeFromUri;
    }

    private String[] computeContentList() {
        return CONTENT_SPLIT_PATTERN.split(this.getContent(), -1);
    }

    private SymbolTree computeSymbolTree() {
        return new SymbolTreeComputer(this).compute();
    }

    private ModuleType computeModuleType() {
        return this.context.getConfiguration().getModuleType(this.uri);
    }

    private Map<SupportConfiguration, SupportVariant> computeSupportVariants() {
        return this.context.getConfiguration().getModuleSupport(this.uri);
    }

    private ComplexityData computeCognitiveComplexity() {
        CognitiveComplexityComputer cognitiveComplexityComputer = new CognitiveComplexityComputer(this);
        return (ComplexityData)cognitiveComplexityComputer.compute();
    }

    private ComplexityData computeCyclomaticComplexity() {
        CyclomaticComplexityComputer cyclomaticComplexityComputer = new CyclomaticComplexityComputer(this);
        return (ComplexityData)cyclomaticComplexityComputer.compute();
    }

    private MetricStorage computeMetrics() {
        MetricStorage metricsTemp = new MetricStorage();
        List<MethodSymbol> methodsUnboxed = this.getSymbolTree().getMethods();
        metricsTemp.setFunctions(Math.toIntExact(methodsUnboxed.stream().filter(MethodSymbol::isFunction).count()));
        metricsTemp.setProcedures(methodsUnboxed.size() - metricsTemp.getFunctions());
        int[] nclocData = this.getTokensFromDefaultChannel().stream().mapToInt(Token::getLine).distinct().toArray();
        metricsTemp.setNclocData(nclocData);
        metricsTemp.setNcloc(nclocData.length);
        List<Token> tokensUnboxed = this.getTokens();
        int lines = tokensUnboxed.isEmpty() ? 0 : tokensUnboxed.get(tokensUnboxed.size() - 1).getLine();
        metricsTemp.setLines(lines);
        int comments = (int)this.getComments().stream().map(Token::getLine).distinct().count();
        metricsTemp.setComments(comments);
        int statements = Trees.findAllRuleNodes((ParseTree)this.getAst(), 77).size();
        metricsTemp.setStatements(statements);
        metricsTemp.setCognitiveComplexity(this.getCognitiveComplexityData().getFileComplexity());
        metricsTemp.setCyclomaticComplexity(this.getCyclomaticComplexityData().getFileComplexity());
        return metricsTemp;
    }

    private DiagnosticIgnoranceComputer.Data computeDiagnosticIgnorance() {
        DiagnosticIgnoranceComputer diagnosticIgnoranceComputer = new DiagnosticIgnoranceComputer(this);
        return (DiagnosticIgnoranceComputer.Data)diagnosticIgnoranceComputer.compute();
    }

    private List<Diagnostic> computeDiagnostics() {
        return this.diagnosticComputer.compute(this);
    }

    private List<SDBLTokenizer> computeQueries() {
        return new QueryComputer(this).compute();
    }

    @ConstructorProperties(value={"uri"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocumentContext(URI uri) {
        this.uri = uri;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getVersion() {
        return this.version;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setContext(ServerContext context) {
        this.context = context;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setDiagnosticComputer(DiagnosticComputer diagnosticComputer) {
        this.diagnosticComputer = diagnosticComputer;
    }

    @Autowired
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }

    static {
        DocumentContext.ajc$preClinit();
        CONTENT_SPLIT_PATTERN = Pattern.compile("\r?\n|\r");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DocumentContext.java", DocumentContext.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rebuild", "com.github._1c_syntax.bsl.languageserver.context.DocumentContext", "java.lang.String:int", "content:version", "", "void"), 259);
    }
}

