/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.cfg.BasicBlockVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgBuildingParseTreeVisitor;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdge;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgEdgeType;
import com.github._1c_syntax.bsl.languageserver.cfg.CfgVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ConditionalVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.ControlFlowGraph;
import com.github._1c_syntax.bsl.languageserver.cfg.ExitVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.LoopVertex;
import com.github._1c_syntax.bsl.languageserver.cfg.WhileLoopVertex;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, tags={DiagnosticTag.UNPREDICTABLE, DiagnosticTag.BADPRACTICE, DiagnosticTag.SUSPICIOUS})
public class AllFunctionPathMustHaveReturnDiagnostic
extends AbstractVisitorDiagnostic {
    private static final boolean LOOPS_EXECUTED_ONCE_DEFAULT = true;
    private static final boolean IGNORE_ELSELESS_SWITCHES = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean loopsExecutedAtLeastOnce = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean ignoreMissingElseOnExit = false;

    public ParseTree visitFunction(BSLParser.FunctionContext ctx) {
        if (ctx.ENDFUNCTION_KEYWORD() == null) {
            return ctx;
        }
        Collection<ParseTree> tokens = Trees.findAllTokenNodes((ParseTree)ctx, 62);
        if (tokens.isEmpty()) {
            return ctx;
        }
        this.checkAllPathsHaveReturns(ctx);
        return ctx;
    }

    private void checkAllPathsHaveReturns(BSLParser.FunctionContext ctx) {
        CfgBuildingParseTreeVisitor builder = new CfgBuildingParseTreeVisitor();
        builder.producePreprocessorConditions(false);
        ControlFlowGraph graph = builder.buildGraph(ctx.subCodeBlock().codeBlock());
        Optional<CfgVertex> exitNode = graph.vertexSet().stream().filter(ExitVertex.class::isInstance).findFirst();
        if (exitNode.isEmpty()) {
            throw new IllegalStateException();
        }
        List incomingVertices = graph.incomingEdgesOf(exitNode.get()).stream().map(arg_0 -> ((ControlFlowGraph)graph).getEdgeSource(arg_0)).map(vertex -> this.nonExplicitReturnNode((CfgVertex)vertex, graph)).flatMap(Optional::stream).collect(Collectors.toList());
        if (incomingVertices.isEmpty()) {
            return;
        }
        ArrayList<DiagnosticRelatedInformation> listOfMessages = new ArrayList<DiagnosticRelatedInformation>();
        listOfMessages.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)ctx.funcDeclaration().subName()), this.info.getMessage()));
        incomingVertices.stream().map(vertex -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)vertex), this.info.getMessage())).collect(Collectors.toCollection(() -> listOfMessages));
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.funcDeclaration().subName(), listOfMessages);
    }

    private Optional<BSLParserRuleContext> nonExplicitReturnNode(CfgVertex v, ControlFlowGraph graph) {
        if (v instanceof BasicBlockVertex) {
            return this.checkBasicBlockExitingNode((BasicBlockVertex)v);
        }
        if (v instanceof LoopVertex) {
            return this.checkLoopExitingNode((LoopVertex)v);
        }
        if (v instanceof ConditionalVertex) {
            return this.checkElseIfClauseExitingNode((ConditionalVertex)v, graph);
        }
        return v.getAst();
    }

    private Optional<BSLParserRuleContext> checkElseIfClauseExitingNode(ConditionalVertex v, ControlFlowGraph graph) {
        Optional<CfgEdge> edgeOrNot = graph.getAllEdges(v, graph.getExitPoint()).stream().filter(edge -> edge.getType() == CfgEdgeType.FALSE_BRANCH).findAny();
        if (edgeOrNot.isEmpty()) {
            return Optional.empty();
        }
        BSLParser.ExpressionContext expression = v.getExpression();
        if (expression.getParent() instanceof BSLParser.ElsifBranchContext && !this.ignoreMissingElseOnExit) {
            return Optional.of((BSLParser.ElsifBranchContext)expression.getParent());
        }
        return Optional.empty();
    }

    private Optional<BSLParserRuleContext> checkBasicBlockExitingNode(BasicBlockVertex block) {
        if (!block.statements().isEmpty()) {
            BSLParserRuleContext lastStatement = block.statements().get(block.statements().size() - 1);
            Collection<ParserRuleContext> nodes = Trees.findAllRuleNodes((ParseTree)lastStatement, 53, 44);
            if (nodes.isEmpty()) {
                return block.getAst();
            }
        }
        return Optional.empty();
    }

    private Optional<BSLParserRuleContext> checkLoopExitingNode(LoopVertex v) {
        WhileLoopVertex whileLoop;
        if (v instanceof WhileLoopVertex && this.isEndlessLoop(whileLoop = (WhileLoopVertex)v)) {
            return Optional.empty();
        }
        if (this.loopsExecutedAtLeastOnce) {
            return Optional.empty();
        }
        return v.getAst();
    }

    private boolean isEndlessLoop(WhileLoopVertex whileLoop) {
        BSLParser.ExpressionContext expression = whileLoop.getExpression();
        return expression.getChildCount() == 1 && expression.member(0).constValue() != null && expression.member(0).constValue().TRUE() != null;
    }
}

