/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.RegionSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, scope=DiagnosticScope.BSL, minutesToFix=1, tags={DiagnosticTag.STANDARD}, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_1)
public class CodeOutOfRegionDiagnostic
extends AbstractVisitorDiagnostic {
    private static final boolean CHECK_UNKNOWN_MODULE_TYPE = false;
    private final List<Range> regionsRanges = new ArrayList<Range>();
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean checkUnknownModuleType = false;

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        if (this.documentContext.getModuleType() == ModuleType.UNKNOWN && !this.checkUnknownModuleType) {
            return ctx;
        }
        List<RegionSymbol> regions = this.documentContext.getSymbolTree().getModuleLevelRegions();
        this.regionsRanges.clear();
        if (regions.isEmpty() && !ctx.getTokens().isEmpty()) {
            List<DiagnosticRelatedInformation> relatedInformation = this.createRelatedInformations(ctx);
            if (!relatedInformation.isEmpty()) {
                this.diagnosticStorage.addDiagnostic(relatedInformation.get(0).getLocation().getRange(), relatedInformation);
            }
            return ctx;
        }
        regions.forEach(region -> this.regionsRanges.add(region.getRange()));
        return (ParseTree)super.visitFile(ctx);
    }

    private List<DiagnosticRelatedInformation> createRelatedInformations(BSLParser.FileContext ctx) {
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        this.addChildrenToRelatedInformation(ctx, relatedInformation, 26, 67);
        this.documentContext.getSymbolTree().getMethods().stream().map(node -> RelatedInformation.create(this.documentContext.getUri(), node.getSubNameRange(), "+1")).collect(Collectors.toCollection(() -> relatedInformation));
        this.addChildrenToRelatedInformation(ctx, relatedInformation, 68);
        return relatedInformation;
    }

    private void addChildrenToRelatedInformation(BSLParser.FileContext ctx, List<DiagnosticRelatedInformation> relatedInformation, Integer ... ruleIndex) {
        Trees.getChildren((Tree)ctx, ruleIndex).stream().filter(node -> !node.getTokens().isEmpty()).map(node -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)node), "+1")).collect(Collectors.toCollection(() -> relatedInformation));
    }

    public ParseTree visitModuleVar(BSLParser.ModuleVarContext ctx) {
        Trees.getChildren((Tree)ctx).stream().filter(node -> !(node instanceof BSLParser.PreprocessorContext) && !(node instanceof TerminalNode)).findFirst().ifPresent(node -> {
            Range ctxRange = Ranges.create((ParserRuleContext)((BSLParserRuleContext)node));
            if (this.regionsRanges.stream().noneMatch(regionRange -> Ranges.containsRange(regionRange, ctxRange))) {
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
            }
        });
        return ctx;
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx).ifPresent(methodSymbol -> {
            if (methodSymbol.getRegion().isEmpty()) {
                this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange());
            }
        });
        return ctx;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        this.addDiagnosticForFileCodeBlock((BSLParserRuleContext)ctx);
        return ctx;
    }

    public ParseTree visitFileCodeBlockBeforeSub(BSLParser.FileCodeBlockBeforeSubContext ctx) {
        this.addDiagnosticForFileCodeBlock((BSLParserRuleContext)ctx);
        return ctx;
    }

    private void addDiagnosticForFileCodeBlock(BSLParserRuleContext ctx) {
        Trees.findAllRuleNodes((ParseTree)ctx, 77).stream().filter(node -> node.getParent().getParent() == ctx).forEach(child -> {
            if (child.getChildCount() > 1 || !(child.getChild(0) instanceof BSLParser.PreprocessorContext)) {
                Range ctxRange = Ranges.create((ParserRuleContext)((BSLParser.StatementContext)child));
                if (this.regionsRanges.stream().noneMatch(regionRange -> Ranges.containsRange(regionRange, ctxRange))) {
                    this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)((BSLParser.StatementContext)child));
                }
            }
        });
    }
}

